/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;

public class LazyDynaMap
extends LazyDynaBean
implements MutableDynaClass {
    protected String name;
    protected boolean restricted;
    protected boolean returnNull = false;

    public LazyDynaMap() {
        this(null, (Map)null);
    }

    public LazyDynaMap(String string) {
        this(string, (Map)null);
    }

    public LazyDynaMap(Map map) {
        this(null, map);
    }

    public LazyDynaMap(String string, Map map) {
        this.name = string == null ? "LazyDynaMap" : string;
        this.values = map == null ? this.newMap() : map;
        this.dynaClass = this;
    }

    public LazyDynaMap(DynaProperty[] dynaPropertyArray) {
        this(null, dynaPropertyArray);
    }

    public LazyDynaMap(String string, DynaProperty[] dynaPropertyArray) {
        this(string, (Map)null);
        if (dynaPropertyArray != null) {
            int n = 0;
            while (n < dynaPropertyArray.length) {
                this.add(dynaPropertyArray[n]);
                ++n;
            }
        }
    }

    public LazyDynaMap(DynaClass dynaClass) {
        this(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public void setMap(Map map) {
        this.values = map;
    }

    public void set(String string, Object object) {
        if (this.isRestricted() && !this.values.containsKey(string)) {
            throw new IllegalArgumentException("Invalid property name '" + string + "' (DynaClass is restricted)");
        }
        this.values.put(string, object);
    }

    public String getName() {
        return this.name;
    }

    public DynaProperty getDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (!this.values.containsKey(string) && this.isReturnNull()) {
            return null;
        }
        Object v = this.values.get(string);
        if (v == null) {
            return new DynaProperty(string);
        }
        return new DynaProperty(string, v.getClass());
    }

    public DynaProperty[] getDynaProperties() {
        int n = 0;
        DynaProperty[] dynaPropertyArray = new DynaProperty[this.values.size()];
        Iterator iterator = this.values.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.values.get(string);
            dynaPropertyArray[n++] = new DynaProperty(string, v == null ? null : v.getClass());
        }
        return dynaPropertyArray;
    }

    public DynaBean newInstance() {
        return new LazyDynaMap(this);
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean bl) {
        this.restricted = bl;
    }

    public void add(String string) {
        this.add(string, null);
    }

    public void add(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No new properties can be added.");
        }
        Object v = this.values.get(string);
        if (v == null) {
            this.values.put(string, clazz == null ? null : this.createProperty(string, clazz));
        }
    }

    public void add(String string, Class clazz, boolean bl, boolean bl2) {
        throw new UnsupportedOperationException("readable/writable properties not supported");
    }

    protected void add(DynaProperty dynaProperty) {
        this.add(dynaProperty.getName(), dynaProperty.getType());
    }

    public void remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No properties can be removed.");
        }
        if (this.values.containsKey(string)) {
            this.values.remove(string);
        }
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean bl) {
        this.returnNull = bl;
    }

    protected boolean isDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        return this.values.containsKey(string);
    }
}

