/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$("org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static WeakHashMap cache = new WeakHashMap();
    static /* synthetic */ Class class$org$apache$commons$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, true);
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                if (Modifier.isPublic(classArray2[n].getModifiers())) {
                    try {
                        method = classArray2[n].getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[n], string, classArray)) != null) break;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Method getMatchingAccessibleMethod(Class var0, String var1_1, Class[] var2_2) {
        if (MethodUtils.log.isTraceEnabled()) {
            MethodUtils.log.trace((Object)("Matching name=" + var1_1 + " on " + var0));
        }
        var3_3 = new MethodDescriptor(var0, var1_1, var2_2, false);
        try {
            var4_4 = (Method)MethodUtils.cache.get(var3_3);
            if (var4_4 != null) {
                return var4_4;
            }
            var4_4 = var0.getMethod(var1_1, var2_2);
            if (MethodUtils.log.isTraceEnabled()) {
                MethodUtils.log.trace((Object)("Found straight match: " + var4_4));
                MethodUtils.log.trace((Object)("isPublic:" + Modifier.isPublic(var4_4.getModifiers())));
            }
            try {
                var4_4.setAccessible(true);
            }
            catch (SecurityException var5_7) {
                if (!MethodUtils.loggedAccessibleWarning) {
                    var6_9 = false;
                    try {
                        var7_11 = System.getProperty("java.specification.version");
                        if (var7_11.charAt(0) == '1' && (var7_11.charAt(0) == '0' || var7_11.charAt(0) == '1' || var7_11.charAt(0) == '2' || var7_11.charAt(0) == '3')) {
                            var6_9 = true;
                        }
                    }
                    catch (SecurityException var7_12) {
                        var6_9 = true;
                    }
                    if (var6_9) {
                        MethodUtils.log.warn((Object)"Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                    }
                    MethodUtils.loggedAccessibleWarning = true;
                }
                MethodUtils.log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)var5_7);
            }
            MethodUtils.cache.put(var3_3, var4_4);
            return var4_4;
        }
        catch (NoSuchMethodException var4_5) {
            var4_6 = var2_2.length;
            var5_8 = var0.getMethods();
            var6_10 = 0;
            var7_13 = var5_8.length;
            ** while (var6_10 < var7_13)
        }
lbl-1000:
        // 1 sources

        {
            if (var5_8[var6_10].getName().equals(var1_1)) {
                if (MethodUtils.log.isTraceEnabled()) {
                    MethodUtils.log.trace((Object)"Found matching name:");
                    MethodUtils.log.trace((Object)var5_8[var6_10]);
                }
                if ((var9_15 = (var8_14 = var5_8[var6_10].getParameterTypes()).length) == var4_6) {
                    var10_16 = true;
                    var11_17 = 0;
                    while (var11_17 < var9_15) {
                        if (MethodUtils.log.isTraceEnabled()) {
                            MethodUtils.log.trace((Object)("Param=" + var2_2[var11_17].getName()));
                            MethodUtils.log.trace((Object)("Method=" + var8_14[var11_17].getName()));
                        }
                        if (!MethodUtils.isAssignmentCompatible(var8_14[var11_17], var2_2[var11_17])) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace((Object)(var8_14[var11_17] + " is not assignable from " + var2_2[var11_17]));
                            }
                            var10_16 = false;
                            break;
                        }
                        ++var11_17;
                    }
                    if (var10_16) {
                        var12_18 = MethodUtils.getAccessibleMethod(var5_8[var6_10]);
                        if (var12_18 != null) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace((Object)(var12_18 + " accessible version of " + var5_8[var6_10]));
                            }
                            try {
                                var12_18.setAccessible(true);
                            }
                            catch (SecurityException var13_19) {
                                if (!MethodUtils.loggedAccessibleWarning) {
                                    MethodUtils.log.warn((Object)"Cannot use JVM pre-1.4 access bug workaround due to restrictive security manager.");
                                    MethodUtils.loggedAccessibleWarning = true;
                                }
                                MethodUtils.log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)var13_19);
                            }
                            MethodUtils.cache.put(var3_3, var12_18);
                            return var12_18;
                        }
                        MethodUtils.log.trace((Object)"Couldn't find accessible method.");
                    }
                }
            }
            ++var6_10;
            continue;
        }
lbl75:
        // 1 sources

        MethodUtils.log.trace((Object)"No match found.");
        return null;
    }

    public static final boolean isAssignmentCompatible(Class clazz, Class clazz2) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz3 = MethodUtils.getPrimitiveWrapper(clazz)) != null) {
            return clazz3.equals(clazz2);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (Float.TYPE.equals(clazz)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (Long.TYPE.equals(clazz)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (Integer.TYPE.equals(clazz)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (Short.TYPE.equals(clazz)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = MethodUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (Byte.TYPE.equals(clazz)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (Double.TYPE.equals(clazz)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (Character.TYPE.equals(clazz)) {
            return class$java$lang$Character == null ? (class$java$lang$Character = MethodUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        return null;
    }

    public static Class getPrimitiveType(Class clazz) {
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz)) {
            return Boolean.TYPE;
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(clazz)) {
            return Float.TYPE;
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(clazz)) {
            return Long.TYPE;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(clazz)) {
            return Integer.TYPE;
        }
        if ((class$java$lang$Short == null ? (class$java$lang$Short = MethodUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(clazz)) {
            return Short.TYPE;
        }
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(clazz)) {
            return Byte.TYPE;
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double).equals(clazz)) {
            return Double.TYPE;
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = MethodUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(clazz)) {
            return Character.TYPE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not a known primitive wrapper class: " + clazz));
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class clazz, String string, Class[] classArray, boolean bl) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (classArray == null) {
                classArray = emptyClassArray;
            }
            this.cls = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
            this.exact = bl;
            this.hashCode = string.length();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

