/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.JDBCDynaClass;

public class RowSetDynaClass
extends JDBCDynaClass
implements DynaClass,
Serializable {
    protected int limit = -1;
    protected List rows = new ArrayList();

    public RowSetDynaClass(ResultSet resultSet) throws SQLException {
        this(resultSet, true, -1);
    }

    public RowSetDynaClass(ResultSet resultSet, int n) throws SQLException {
        this(resultSet, true, n);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean bl) throws SQLException {
        this(resultSet, bl, -1);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean bl, int n) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        this.lowerCase = bl;
        this.limit = n;
        this.introspect(resultSet);
        this.copy(resultSet);
    }

    public List getRows() {
        return this.rows;
    }

    protected void copy(ResultSet resultSet) throws SQLException {
        int n = 0;
        while (resultSet.next() && (this.limit < 0 || n++ < this.limit)) {
            DynaBean dynaBean = this.createDynaBean();
            int n2 = 0;
            while (n2 < this.properties.length) {
                String string = this.properties[n2].getName();
                dynaBean.set(string, resultSet.getObject(string));
                ++n2;
            }
            this.rows.add(dynaBean);
        }
    }

    protected DynaBean createDynaBean() {
        return new BasicDynaBean(this);
    }
}

