/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtilsBean {
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized = false;
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$locale$LocaleConvertUtils == null ? (class$org$apache$commons$beanutils$locale$LocaleConvertUtils = LocaleConvertUtilsBean.class$("org.apache.commons.beanutils.locale.LocaleConvertUtils")) : class$org$apache$commons$beanutils$locale$LocaleConvertUtils));
    private FastHashMap mapConverters = new FastHashMap();
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$LocaleConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        this.deregister();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public void setApplyLocalized(boolean bl) {
        this.applyLocalized = bl;
    }

    public String convert(Object object) {
        return this.convert(object, this.defaultLocale, null);
    }

    public String convert(Object object, String string) {
        return this.convert(object, this.defaultLocale, string);
    }

    public String convert(Object object, Locale locale, String string) {
        LocaleConverter localeConverter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, locale);
        return (String)localeConverter.convert(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, object, string);
    }

    public Object convert(String string, Class clazz) {
        return this.convert(string, clazz, this.defaultLocale, null);
    }

    public Object convert(String string, Class clazz, String string2) {
        return this.convert(string, clazz, this.defaultLocale, string2);
    }

    public Object convert(String string, Class clazz, Locale locale, String string2) {
        LocaleConverter localeConverter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert string " + string + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + string2 + " pattern"));
        }
        if ((localeConverter = this.lookup(clazz, locale)) == null) {
            localeConverter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, locale);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + localeConverter));
        }
        return localeConverter.convert(clazz, string, string2);
    }

    public Object convert(String[] stringArray, Class clazz, String string) {
        return this.convert(stringArray, clazz, this.getDefaultLocale(), string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        return this.convert(stringArray, clazz, this.getDefaultLocale(), null);
    }

    public Object convert(String[] stringArray, Class clazz, Locale locale, String string) {
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert String[" + stringArray.length + "] to class " + clazz2.getName() + "[] using " + locale.toString() + " locale and " + string + " pattern"));
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            Array.set(object, n, this.convert(stringArray[n], clazz2, locale, string));
            ++n;
        }
        return object;
    }

    public void register(LocaleConverter localeConverter, Class clazz, Locale locale) {
        this.lookup(locale).put(clazz, localeConverter);
    }

    public void deregister() {
        FastHashMap fastHashMap = this.lookup(this.defaultLocale);
        this.mapConverters.setFast(false);
        this.mapConverters.clear();
        this.mapConverters.put(this.defaultLocale, fastHashMap);
        this.mapConverters.setFast(true);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove(locale);
    }

    public void deregister(Class clazz, Locale locale) {
        this.lookup(locale).remove(clazz);
    }

    public LocaleConverter lookup(Class clazz, Locale locale) {
        LocaleConverter localeConverter = (LocaleConverter)this.lookup(locale).get(clazz);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("LocaleConverter:" + localeConverter));
        }
        return localeConverter;
    }

    protected FastHashMap lookup(Locale locale) {
        FastHashMap fastHashMap;
        if (locale == null) {
            fastHashMap = (FastHashMap)this.mapConverters.get(this.defaultLocale);
        } else {
            fastHashMap = (FastHashMap)this.mapConverters.get(locale);
            if (fastHashMap == null) {
                fastHashMap = this.create(locale);
                this.mapConverters.put(locale, fastHashMap);
            }
        }
        return fastHashMap;
    }

    protected FastHashMap create(Locale locale) {
        FastHashMap fastHashMap = new FastHashMap();
        fastHashMap.setFast(false);
        fastHashMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = LocaleConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = LocaleConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = LocaleConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Byte.TYPE, new ByteLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$Double == null ? (class$java$lang$Double = LocaleConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double, new DoubleLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Double.TYPE, new DoubleLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$Float == null ? (class$java$lang$Float = LocaleConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float, new FloatLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Float.TYPE, new FloatLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = LocaleConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Integer.TYPE, new IntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$Long == null ? (class$java$lang$Long = LocaleConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long, new LongLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Long.TYPE, new LongLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$Short == null ? (class$java$lang$Short = LocaleConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short, new ShortLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Short.TYPE, new ShortLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, new StringLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(class$java$sql$Date == null ? (class$java$sql$Date = LocaleConvertUtilsBean.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateLocaleConverter(locale, "yyyy-MM-dd"));
        fastHashMap.put(class$java$sql$Time == null ? (class$java$sql$Time = LocaleConvertUtilsBean.class$("java.sql.Time")) : class$java$sql$Time, new SqlTimeLocaleConverter(locale, "HH:mm:ss"));
        fastHashMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = LocaleConvertUtilsBean.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlTimestampLocaleConverter(locale, "yyyy-MM-dd HH:mm:ss.S"));
        fastHashMap.setFast(true);
        return fastHashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

