/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.DeferredFileOutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class DefaultFileItem
implements FileItem {
    private static int counter = 0;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private int sizeThreshold;
    private File repository;
    private byte[] cachedContent;
    private DeferredFileOutputStream dfos;
    static /* synthetic */ Class class$org$apache$commons$fileupload$DefaultFileItem;

    DefaultFileItem(String string, String string2, boolean bl, String string3, int n, File file) {
        this.fieldName = string;
        this.contentType = string2;
        this.isFormField = bl;
        this.fileName = string3;
        this.sizeThreshold = n;
        this.repository = file;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.dfos.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] get() {
        if (this.dfos.isInMemory()) {
            if (this.cachedContent != null) return this.cachedContent;
            this.cachedContent = this.dfos.getData();
            return this.cachedContent;
        }
        byte[] byArray = new byte[(int)this.getSize()];
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(this.dfos.getFile());
        fileInputStream.read(byArray);
        Object var5_3 = null;
        if (fileInputStream == null) return byArray;
        try {
            fileInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
        {
            catch (IOException iOException) {
                byArray = null;
                Object var5_4 = null;
                if (fileInputStream == null) return byArray;
                try {
                    fileInputStream.close();
                    return byArray;
                }
                catch (IOException iOException2) {}
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getString(String string) throws UnsupportedEncodingException {
        return new String(this.get(), string);
    }

    public String getString() {
        return new String(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file) throws Exception {
        if (this.isInMemory()) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.get());
                Object var4_4 = null;
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        File file2 = this.getStoreLocation();
        if (file2 == null) throw new FileUploadException("Cannot write uploaded file to disk!");
        if (file2.renameTo(file)) return;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                filterOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            filterOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void delete() {
        this.cachedContent = null;
        File file = this.getStoreLocation();
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean bl) {
        this.isFormField = bl;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            File file = this.getTempFile();
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, file);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos.getFile();
    }

    protected void finalize() {
        File file = this.dfos.getFile();
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    protected File getTempFile() {
        File file = this.repository;
        if (file == null) {
            file = new File(System.getProperty("java.io.tmpdir"));
        }
        String string = "upload_" + DefaultFileItem.getUniqueId() + ".tmp";
        File file2 = new File(file, string);
        file2.deleteOnExit();
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        int n;
        Class clazz = class$org$apache$commons$fileupload$DefaultFileItem == null ? (class$org$apache$commons$fileupload$DefaultFileItem = DefaultFileItem.class$("org.apache.commons.fileupload.DefaultFileItem")) : class$org$apache$commons$fileupload$DefaultFileItem;
        synchronized (clazz) {
            n = counter++;
        }
        String string = Integer.toString(n);
        if (n < 100000000) {
            string = ("00000000" + string).substring(string.length());
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

