/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.fileupload.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private FileOutputStream diskOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;

    public DeferredFileOutputStream(int n, File file) {
        super(n);
        this.outputFile = file;
        this.memoryOutputStream = new ByteArrayOutputStream(n);
        this.currentOutputStream = this.memoryOutputStream;
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        byte[] byArray = this.memoryOutputStream.toByteArray();
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
        fileOutputStream.write(byArray);
        this.diskOutputStream = fileOutputStream;
        this.currentOutputStream = fileOutputStream;
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }
}

