/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;

public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int MAX_HEADER_SIZE = 1024;
    private long sizeMax = -1L;
    private String headerEncoding;

    public static final boolean isMultipartContent(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader(CONTENT_TYPE);
        if (string == null) {
            return false;
        }
        return string.startsWith(MULTIPART);
    }

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long l) {
        this.sizeMax = l;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String string) {
        this.headerEncoding = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseRequest(HttpServletRequest httpServletRequest) throws FileUploadException {
        if (null == httpServletRequest) {
            throw new NullPointerException("req parameter");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = httpServletRequest.getHeader(CONTENT_TYPE);
        if (null == string || !string.startsWith(MULTIPART)) {
            throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + string);
        }
        int n = httpServletRequest.getContentLength();
        if (n == -1) {
            throw new UnknownSizeException("the request was rejected because it's size is unknown");
        }
        if (this.sizeMax >= 0L && (long)n > this.sizeMax) {
            throw new SizeLimitExceededException("the request was rejected because it's size exceeds allowed range");
        }
        try {
            int n2 = string.indexOf("boundary=");
            if (n2 < 0) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            byte[] byArray = string.substring(n2 + 9).getBytes();
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            MultipartStream multipartStream = new MultipartStream((InputStream)servletInputStream, byArray);
            multipartStream.setHeaderEncoding(this.headerEncoding);
            boolean bl = multipartStream.skipPreamble();
            while (bl) {
                Map map = this.parseHeaders(multipartStream.readHeaders());
                String string2 = this.getFieldName(map);
                if (string2 != null) {
                    Object object;
                    String string3 = this.getHeader(map, CONTENT_TYPE);
                    if (string3 != null && string3.startsWith(MULTIPART_MIXED)) {
                        object = string3.substring(string3.indexOf("boundary=") + 9).getBytes();
                        multipartStream.setBoundary((byte[])object);
                        boolean bl2 = multipartStream.skipPreamble();
                        while (bl2) {
                            map = this.parseHeaders(multipartStream.readHeaders());
                            if (this.getFileName(map) != null) {
                                Object var18_20;
                                FileItem fileItem = this.createItem(map, false);
                                OutputStream outputStream = fileItem.getOutputStream();
                                try {
                                    multipartStream.readBodyData(outputStream);
                                    var18_20 = null;
                                }
                                catch (Throwable throwable) {
                                    var18_20 = null;
                                    outputStream.close();
                                    throw throwable;
                                }
                                outputStream.close();
                                arrayList.add(fileItem);
                            } else {
                                multipartStream.discardBodyData();
                            }
                            bl2 = multipartStream.readBoundary();
                        }
                        multipartStream.setBoundary(byArray);
                    } else if (this.getFileName(map) != null) {
                        Object var20_21;
                        object = this.createItem(map, false);
                        OutputStream outputStream = object.getOutputStream();
                        try {
                            multipartStream.readBodyData(outputStream);
                            var20_21 = null;
                        }
                        catch (Throwable throwable) {
                            var20_21 = null;
                            outputStream.close();
                            throw throwable;
                        }
                        outputStream.close();
                        arrayList.add(object);
                    } else {
                        Object var22_22;
                        object = this.createItem(map, true);
                        OutputStream outputStream = object.getOutputStream();
                        try {
                            multipartStream.readBodyData(outputStream);
                            var22_22 = null;
                        }
                        catch (Throwable throwable) {
                            var22_22 = null;
                            outputStream.close();
                            throw throwable;
                        }
                        outputStream.close();
                        arrayList.add(object);
                    }
                } else {
                    multipartStream.discardBodyData();
                }
                bl = multipartStream.readBoundary();
            }
        }
        catch (IOException iOException) {
            throw new FileUploadException("Processing of multipart/form-data request failed. " + iOException.getMessage());
        }
        return arrayList;
    }

    protected String getFileName(Map map) {
        String string = null;
        String string2 = this.getHeader(map, CONTENT_DISPOSITION);
        if (string2.startsWith(FORM_DATA) || string2.startsWith(ATTACHMENT)) {
            int n = string2.indexOf("filename=\"");
            int n2 = string2.indexOf(34, n + 10);
            if (n != -1 && n2 != -1) {
                string = string2.substring(n + 10, n2).trim();
            }
        }
        return string;
    }

    protected String getFieldName(Map map) {
        String string = null;
        String string2 = this.getHeader(map, CONTENT_DISPOSITION);
        if (string2 != null && string2.startsWith(FORM_DATA)) {
            int n = string2.indexOf("name=\"");
            int n2 = string2.indexOf(34, n + 6);
            if (n != -1 && n2 != -1) {
                string = string2.substring(n + 6, n2);
            }
        }
        return string;
    }

    protected FileItem createItem(Map map, boolean bl) throws FileUploadException {
        return this.getFileItemFactory().createItem(this.getFieldName(map), this.getHeader(map, CONTENT_TYPE), bl, this.getFileName(map));
    }

    protected Map parseHeaders(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        char[] cArray = new char[1024];
        boolean bl = false;
        int n = 0;
        try {
            while (!bl) {
                int n2 = 0;
                while (n2 < 2 || cArray[n2 - 2] != '\r' || cArray[n2 - 1] != '\n') {
                    cArray[n2++] = string.charAt(n++);
                }
                String string2 = new String(cArray, 0, n2 - 2);
                if (string2.equals("")) {
                    bl = true;
                    continue;
                }
                if (string2.indexOf(58) == -1) continue;
                String string3 = string2.substring(0, string2.indexOf(58)).trim().toLowerCase();
                String string4 = string2.substring(string2.indexOf(58) + 1).trim();
                if (this.getHeader(hashMap, string3) != null) {
                    hashMap.put(string3, this.getHeader(hashMap, string3) + ',' + string4);
                    continue;
                }
                hashMap.put(string3, string4);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return hashMap;
    }

    protected final String getHeader(Map map, String string) {
        return (String)map.get(string.toLowerCase());
    }

    public static class InvalidContentTypeException
    extends FileUploadException {
        public InvalidContentTypeException() {
        }

        public InvalidContentTypeException(String string) {
            super(string);
        }
    }

    public static class SizeLimitExceededException
    extends FileUploadException {
        public SizeLimitExceededException() {
        }

        public SizeLimitExceededException(String string) {
            super(string);
        }
    }

    public static class UnknownSizeException
    extends FileUploadException {
        public UnknownSizeException() {
        }

        public UnknownSizeException(String string) {
            super(string);
        }
    }
}

