/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.validator.util.Flags;

public class CreditCardValidator {
    public static final int NONE = 0;
    public static final int AMEX = 1;
    public static final int VISA = 2;
    public static final int MASTERCARD = 4;
    public static final int DISCOVER = 8;
    private Collection cardTypes = new ArrayList();

    public CreditCardValidator() {
        this(15);
    }

    public CreditCardValidator(int n) {
        Flags flags = new Flags(n);
        if (flags.isOn(2L)) {
            this.cardTypes.add(new Visa());
        }
        if (flags.isOn(1L)) {
            this.cardTypes.add(new Amex());
        }
        if (flags.isOn(4L)) {
            this.cardTypes.add(new Mastercard());
        }
        if (flags.isOn(8L)) {
            this.cardTypes.add(new Discover());
        }
    }

    public boolean isValid(String string) {
        if (string == null || string.length() < 13 || string.length() > 19) {
            return false;
        }
        if (!this.luhnCheck(string)) {
            return false;
        }
        Iterator iterator = this.cardTypes.iterator();
        while (iterator.hasNext()) {
            CreditCardType creditCardType = (CreditCardType)iterator.next();
            if (!creditCardType.matches(string)) continue;
            return true;
        }
        return false;
    }

    public void addAllowedCardType(CreditCardType creditCardType) {
        this.cardTypes.add(creditCardType);
    }

    protected boolean luhnCheck(String string) {
        int n = string.length();
        int n2 = n & 1;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string.charAt(i) + "");
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if ((i & 1 ^ n2) == 0 && (n3 *= 2) > 9) {
                n3 -= 9;
            }
            l += (long)n3;
        }
        return l == 0L ? false : l % 10L == 0L;
    }

    protected boolean isValidPrefix(String string) {
        if (string.length() < 13) {
            return false;
        }
        return new Visa().matches(string) || new Amex().matches(string) || new Mastercard().matches(string) || new Discover().matches(string);
    }

    private class Amex
    implements CreditCardType {
        private static final String PREFIX = "34,37,";

        private Amex() {
        }

        public boolean matches(String string) {
            String string2 = string.substring(0, 2) + ",";
            return PREFIX.indexOf(string2) != -1 && string.length() == 15;
        }
    }

    public static interface CreditCardType {
        public boolean matches(String var1);
    }

    private class Discover
    implements CreditCardType {
        private static final String PREFIX = "6011";

        private Discover() {
        }

        public boolean matches(String string) {
            return string.substring(0, 4).equals(PREFIX) && string.length() == 16;
        }
    }

    private class Mastercard
    implements CreditCardType {
        private static final String PREFIX = "51,52,53,54,55,";

        private Mastercard() {
        }

        public boolean matches(String string) {
            String string2 = string.substring(0, 2) + ",";
            return PREFIX.indexOf(string2) != -1 && string.length() == 16;
        }
    }

    private class Visa
    implements CreditCardType {
        private static final String PREFIX = "4";

        private Visa() {
        }

        public boolean matches(String string) {
            return string.substring(0, 1).equals(PREFIX) && (string.length() == 13 || string.length() == 16);
        }
    }
}

