/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DateValidator {
    private static final DateValidator instance = new DateValidator();

    public static DateValidator getInstance() {
        return instance;
    }

    protected DateValidator() {
    }

    public boolean isValid(String string, String string2, boolean bl) {
        if (string == null || string2 == null || string2.length() <= 0) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setLenient(false);
        try {
            simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return !bl || string2.length() == string.length();
    }

    public boolean isValid(String string, Locale locale) {
        if (string == null) {
            return false;
        }
        DateFormat dateFormat = null;
        dateFormat = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }
}

