/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import org.apache.oro.text.perl.Perl5Util;

public class EmailValidator {
    private static final String SPECIAL_CHARS = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"[^\"]*\")";
    private static final String ATOM = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+";
    private static final String WORD = "([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))";
    private static final String LEGAL_ASCII_PATTERN = "/^[\\000-\\177]+$/";
    private static final String EMAIL_PATTERN = "/^(.+)@(.+)$/";
    private static final String IP_DOMAIN_PATTERN = "/^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$/";
    private static final String USER_PATTERN = "/^([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))(\\.([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\")))*$/";
    private static final String DOMAIN_PATTERN = "/^[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+(\\.[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)*$/";
    private static final String ATOM_PATTERN = "/([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)/";
    private static final EmailValidator instance = new EmailValidator();

    public static EmailValidator getInstance() {
        return instance;
    }

    protected EmailValidator() {
    }

    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        Perl5Util perl5Util = new Perl5Util();
        if (!perl5Util.match(LEGAL_ASCII_PATTERN, string)) {
            return false;
        }
        Perl5Util perl5Util2 = new Perl5Util();
        if (!perl5Util2.match(EMAIL_PATTERN, string)) {
            return false;
        }
        if (string.endsWith(".")) {
            return false;
        }
        if (!this.isValidUser(perl5Util2.group(1))) {
            return false;
        }
        return this.isValidDomain(perl5Util2.group(2));
    }

    protected boolean isValidDomain(String string) {
        boolean bl = false;
        Perl5Util perl5Util = new Perl5Util();
        if (perl5Util.match(IP_DOMAIN_PATTERN, string)) {
            if (!this.isValidIpAddress(perl5Util)) {
                return false;
            }
        } else {
            Perl5Util perl5Util2 = new Perl5Util();
            bl = perl5Util2.match(DOMAIN_PATTERN, string);
        }
        if (bl) {
            return this.isValidSymbolicDomain(string);
        }
        return false;
    }

    protected boolean isValidUser(String string) {
        Perl5Util perl5Util = new Perl5Util();
        return perl5Util.match(USER_PATTERN, string);
    }

    protected boolean isValidIpAddress(Perl5Util perl5Util) {
        for (int i = 1; i <= 4; ++i) {
            String string = perl5Util.group(i);
            if (string == null || string.length() <= 0) {
                return false;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n <= 255) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidSymbolicDomain(String string) {
        int n;
        String[] stringArray = new String[10];
        boolean bl = true;
        int n2 = 0;
        Perl5Util perl5Util = new Perl5Util();
        while (bl) {
            bl = perl5Util.match(ATOM_PATTERN, string);
            if (!bl) continue;
            stringArray[n2] = perl5Util.group(1);
            n = stringArray[n2].length() + 1;
            string = n >= string.length() ? "" : string.substring(n);
            ++n2;
        }
        n = n2;
        if (stringArray[n - 1].length() < 2 || stringArray[n - 1].length() > 4) {
            return false;
        }
        return n >= 2;
    }
}

