/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;

public class Field
implements Cloneable,
Serializable {
    private static final String DEFAULT_ARG = "org.apache.commons.validator.Field.DEFAULT";
    public static final String ARG_DEFAULT = "org.apache.commons.validator.Field.DEFAULT";
    public static final String TOKEN_INDEXED = "[]";
    protected static final String TOKEN_START = "${";
    protected static final String TOKEN_END = "}";
    protected static final String TOKEN_VAR = "var:";
    protected String property = null;
    protected String indexedProperty = null;
    protected String indexedListProperty = null;
    protected String key = null;
    protected String depends = null;
    protected int page = 0;
    protected int fieldOrder = 0;
    protected FastHashMap hDependencies = new FastHashMap();
    private List dependencyList = Collections.synchronizedList(new ArrayList());
    protected FastHashMap hVars = new FastHashMap();
    protected FastHashMap hMsgs = new FastHashMap();
    protected Map[] args = new Map[0];
    protected FastHashMap hArg0 = new FastHashMap();
    protected FastHashMap hArg1 = new FastHashMap();
    protected FastHashMap hArg2 = new FastHashMap();
    protected FastHashMap hArg3 = new FastHashMap();

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(int n) {
        this.fieldOrder = n;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public String getIndexedProperty() {
        return this.indexedProperty;
    }

    public void setIndexedProperty(String string) {
        this.indexedProperty = string;
    }

    public String getIndexedListProperty() {
        return this.indexedListProperty;
    }

    public void setIndexedListProperty(String string) {
        this.indexedListProperty = string;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String string) {
        this.depends = string;
        this.dependencyList.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.length() <= 0) continue;
            this.dependencyList.add(string2);
        }
    }

    public void addMsg(Msg msg) {
        this.hMsgs.put((Object)msg.getName(), (Object)msg);
    }

    public String getMsg(String string) {
        Msg msg = this.getMessage(string);
        return msg == null ? null : msg.getKey();
    }

    public Msg getMessage(String string) {
        return (Msg)this.hMsgs.get((Object)string);
    }

    public Map getMessages() {
        return Collections.unmodifiableMap(this.hMsgs);
    }

    public void addArg(Arg arg) {
        if (arg == null || arg.getKey() == null || arg.getKey().length() == 0) {
            return;
        }
        this.ensureArgsCapacity(arg);
        HashMap<String, Arg> hashMap = this.args[arg.getPosition()];
        if (hashMap == null) {
            this.args[arg.getPosition()] = hashMap = new HashMap<String, Arg>();
        }
        if (arg.getName() == null) {
            hashMap.put("org.apache.commons.validator.Field.DEFAULT", arg);
        } else {
            hashMap.put(arg.getName(), arg);
        }
    }

    private void ensureArgsCapacity(Arg arg) {
        if (arg.getPosition() >= this.args.length) {
            Map[] mapArray = new Map[arg.getPosition() + 1];
            System.arraycopy(this.args, 0, mapArray, 0, this.args.length);
            this.args = mapArray;
        }
    }

    public Arg getArg(int n) {
        return this.getArg("org.apache.commons.validator.Field.DEFAULT", n);
    }

    public Arg getArg(String string, int n) {
        if (n >= this.args.length || this.args[n] == null) {
            return null;
        }
        Arg arg = (Arg)this.args[n].get(string);
        if (arg == null && string.equals("org.apache.commons.validator.Field.DEFAULT")) {
            return null;
        }
        return arg == null ? this.getArg(n) : arg;
    }

    public Arg[] getArgs(String string) {
        Arg[] argArray = new Arg[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            argArray[i] = this.getArg(string, i);
        }
        return argArray;
    }

    public void addArg0(Arg arg) {
        arg.setPosition(0);
        this.addArg(arg);
    }

    public Arg getArg0() {
        return this.getArg(0);
    }

    public Arg getArg0(String string) {
        return this.getArg(string, 0);
    }

    public void addArg1(Arg arg) {
        arg.setPosition(1);
        this.addArg(arg);
    }

    public Arg getArg1() {
        return this.getArg(1);
    }

    public Arg getArg1(String string) {
        return this.getArg(string, 1);
    }

    public void addArg2(Arg arg) {
        arg.setPosition(2);
        this.addArg(arg);
    }

    public Arg getArg2() {
        return this.getArg(2);
    }

    public Arg getArg2(String string) {
        return this.getArg(string, 2);
    }

    public void addArg3(Arg arg) {
        arg.setPosition(3);
        this.addArg(arg);
    }

    public Arg getArg3() {
        return this.getArg(3);
    }

    public Arg getArg3(String string) {
        return this.getArg(string, 3);
    }

    public void addVar(Var var) {
        this.hVars.put((Object)var.getName(), (Object)var);
    }

    public void addVarParam(String string, String string2, String string3) {
        this.addVar(new Var(string, string2, string3));
    }

    public void addVar(String string, String string2, String string3) {
        this.addVar(new Var(string, string2, string3));
    }

    public Var getVar(String string) {
        return (Var)this.hVars.get((Object)string);
    }

    public String getVarValue(String string) {
        String string2 = null;
        Object object = this.hVars.get((Object)string);
        if (object != null && object instanceof Var) {
            Var var = (Var)object;
            string2 = var.getValue();
        }
        return string2;
    }

    public Map getVars() {
        return Collections.unmodifiableMap(this.hVars);
    }

    public String getKey() {
        if (this.key == null) {
            this.generateKey();
        }
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public boolean isIndexed() {
        return this.indexedListProperty != null && this.indexedListProperty.length() > 0;
    }

    public void generateKey() {
        this.key = this.isIndexed() ? this.indexedListProperty + TOKEN_INDEXED + "." + this.property : this.property;
    }

    public void process(Map map, Map map2) {
        Object object;
        String string;
        String string2;
        this.hMsgs.setFast(false);
        this.hVars.setFast(true);
        this.generateKey();
        Iterator<Object> iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = TOKEN_START + string2 + TOKEN_END;
            object = (String)map2.get(string2);
            this.property = ValidatorUtils.replace(this.property, string, (String)object);
            this.processVars(string, (String)object);
            this.processMessageComponents(string, (String)object);
        }
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = TOKEN_START + string2 + TOKEN_END;
            object = (String)map.get(string2);
            this.property = ValidatorUtils.replace(this.property, string, (String)object);
            this.processVars(string, (String)object);
            this.processMessageComponents(string, (String)object);
        }
        iterator = this.hVars.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = "${var:" + string2 + TOKEN_END;
            object = this.getVar(string2);
            String string3 = ((Var)object).getValue();
            this.processMessageComponents(string, string3);
        }
        this.hMsgs.setFast(true);
    }

    private void processVars(String string, String string2) {
        Iterator iterator = this.hVars.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Var var = this.getVar(string3);
            var.setValue(ValidatorUtils.replace(var.getValue(), string, string2));
        }
    }

    public void processMessageComponents(String string, String string2) {
        this.internalProcessMessageComponents(string, string2);
    }

    private void internalProcessMessageComponents(String string, String string2) {
        String string3 = "${var:";
        if (string != null && !string.startsWith(string3)) {
            Iterator iterator = this.hMsgs.values().iterator();
            while (iterator.hasNext()) {
                Msg msg = (Msg)iterator.next();
                msg.setKey(ValidatorUtils.replace(msg.getKey(), string, string2));
            }
        }
        this.processArg(string, string2);
    }

    private void processArg(String string, String string2) {
        for (int i = 0; i < this.args.length; ++i) {
            Map map = this.args[i];
            if (map == null) continue;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Arg arg = (Arg)iterator.next();
                if (arg == null) continue;
                arg.setKey(ValidatorUtils.replace(arg.getKey(), string, string2));
            }
        }
    }

    public boolean isDependency(String string) {
        return this.dependencyList.contains(string);
    }

    public Collection getDependencies() {
        return this.getDependencyList();
    }

    public List getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public Object clone() {
        Field field = null;
        try {
            field = (Field)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
        field.args = new Map[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.args[i]);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Arg arg = (Arg)hashMap.get(string);
                hashMap.put(string, arg.clone());
            }
            field.args[i] = hashMap;
        }
        field.hVars = ValidatorUtils.copyFastHashMap(this.hVars);
        field.hMsgs = ValidatorUtils.copyFastHashMap(this.hMsgs);
        field.hArg0 = ValidatorUtils.copyFastHashMap(this.hArg0);
        field.hArg1 = ValidatorUtils.copyFastHashMap(this.hArg1);
        field.hArg2 = ValidatorUtils.copyFastHashMap(this.hArg2);
        field.hArg3 = ValidatorUtils.copyFastHashMap(this.hArg3);
        return field;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tkey = " + this.key + "\n");
        stringBuffer.append("\t\tproperty = " + this.property + "\n");
        stringBuffer.append("\t\tindexedProperty = " + this.indexedProperty + "\n");
        stringBuffer.append("\t\tindexedListProperty = " + this.indexedListProperty + "\n");
        stringBuffer.append("\t\tdepends = " + this.depends + "\n");
        stringBuffer.append("\t\tpage = " + this.page + "\n");
        stringBuffer.append("\t\tfieldOrder = " + this.fieldOrder + "\n");
        if (this.hVars != null) {
            stringBuffer.append("\t\tVars:\n");
            Iterator iterator = this.hVars.keySet().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                stringBuffer.append("\t\t\t");
                stringBuffer.append(e);
                stringBuffer.append("=");
                stringBuffer.append(this.hVars.get(e));
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    Object[] getIndexedProperty(Object object) throws ValidatorException {
        Object object2 = null;
        try {
            object2 = PropertyUtils.getProperty((Object)object, (String)this.getIndexedListProperty());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ValidatorException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ValidatorException(invocationTargetException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ValidatorException(noSuchMethodException.getMessage());
        }
        if (object2 instanceof Collection) {
            return ((Collection)object2).toArray();
        }
        if (object2.getClass().isArray()) {
            return (Object[])object2;
        }
        throw new ValidatorException(this.getKey() + " is not indexed");
    }

    private boolean validateForRule(ValidatorAction validatorAction, ValidatorResults validatorResults, Map map, Map map2, int n) throws ValidatorException {
        ValidatorResult validatorResult = validatorResults.getValidatorResult(this.getKey());
        if (validatorResult != null && validatorResult.containsAction(validatorAction.getName())) {
            return validatorResult.isValid(validatorAction.getName());
        }
        if (!this.runDependentValidators(validatorAction, validatorResults, map, map2, n)) {
            return false;
        }
        return validatorAction.executeValidationMethod(this, map2, validatorResults, n);
    }

    private boolean runDependentValidators(ValidatorAction validatorAction, ValidatorResults validatorResults, Map map, Map map2, int n) throws ValidatorException {
        List list = validatorAction.getDependencyList();
        if (list.isEmpty()) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ValidatorAction validatorAction2 = (ValidatorAction)map.get(string);
            if (validatorAction2 == null) {
                this.handleMissingAction(string);
            }
            if (this.validateForRule(validatorAction2, validatorResults, map, map2, n)) continue;
            return false;
        }
        return true;
    }

    ValidatorResults validate(Map map, Map map2) throws ValidatorException {
        if (this.getDepends() == null) {
            return new ValidatorResults();
        }
        ValidatorResults validatorResults = new ValidatorResults();
        Object v = map.get("java.lang.Object");
        int n = this.isIndexed() ? this.getIndexedProperty(v).length : 1;
        for (int i = 0; i < n; ++i) {
            Iterator iterator = this.dependencyList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ValidatorAction validatorAction = (ValidatorAction)map2.get(string);
                if (validatorAction == null) {
                    this.handleMissingAction(string);
                }
                ValidatorResults validatorResults2 = new ValidatorResults();
                boolean bl = this.validateForRule(validatorAction, validatorResults2, map2, map, i);
                validatorResults.merge(validatorResults2);
                if (bl) continue;
                return validatorResults;
            }
        }
        return validatorResults;
    }

    private void handleMissingAction(String string) throws ValidatorException {
        throw new ValidatorException("No ValidatorAction named " + string + " found for field " + this.getProperty());
    }
}

