/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;

public class Form
implements Serializable {
    protected String name = null;
    protected List lFields = new ArrayList();
    protected FastHashMap hFields = new FastHashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addField(Field field) {
        this.lFields.add(field);
        this.hFields.put((Object)field.getKey(), (Object)field);
    }

    public List getFields() {
        return Collections.unmodifiableList(this.lFields);
    }

    public Map getFieldMap() {
        return Collections.unmodifiableMap(this.hFields);
    }

    public Field getField(String string) {
        return (Field)this.hFields.get((Object)string);
    }

    public boolean containsField(String string) {
        return this.hFields.containsKey((Object)string);
    }

    public void process(Map map, Map map2) {
        this.hFields.setFast(true);
        Iterator iterator = this.lFields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            field.process(map, map2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Form: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        Iterator iterator = this.lFields.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\tField: \n");
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    ValidatorResults validate(Map map, Map map2, int n) throws ValidatorException {
        ValidatorResults validatorResults = new ValidatorResults();
        Iterator iterator = this.lFields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            map.put("org.apache.commons.validator.Field", field);
            if (field.getPage() > n) continue;
            validatorResults.merge(field.validate(map, map2));
        }
        return validatorResults;
    }
}

