/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Form;

public class FormSet
implements Serializable {
    private boolean processed = false;
    private String language = null;
    private String country = null;
    private String variant = null;
    private Map forms = new HashMap();
    private Map constants = new HashMap();

    public boolean isProcessed() {
        return this.processed;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String string) {
        this.country = string;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String string) {
        this.variant = string;
    }

    public void addConstant(Constant constant) {
        if (constant.getName() != null && constant.getName().length() > 0 && constant.getValue() != null && constant.getValue().length() > 0) {
            this.constants.put(constant.getName(), constant.getValue());
        }
    }

    public void addConstantParam(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.constants.put(string, string2);
        }
    }

    public void addConstant(String string, String string2) {
        this.constants.put(string, string2);
    }

    public void addForm(Form form) {
        this.forms.put(form.getName(), form);
    }

    public Form getForm(Object object) {
        return (Form)this.forms.get(object);
    }

    public Form getForm(String string) {
        return (Form)this.forms.get(string);
    }

    public Map getForms() {
        return Collections.unmodifiableMap(this.forms);
    }

    public synchronized void process(Map map) {
        Iterator iterator = this.forms.values().iterator();
        while (iterator.hasNext()) {
            Form form = (Form)iterator.next();
            form.process(map, this.constants);
        }
        this.processed = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FormSet: language=");
        stringBuffer.append(this.language);
        stringBuffer.append("  country=");
        stringBuffer.append(this.country);
        stringBuffer.append("  variant=");
        stringBuffer.append(this.variant);
        stringBuffer.append("\n");
        Iterator iterator = this.getForms().values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("   ");
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

