/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.GenericValidator;

public class GenericTypeValidator
implements Serializable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$GenericTypeValidator == null ? (class$org$apache$commons$validator$GenericTypeValidator = GenericTypeValidator.class$("org.apache.commons.validator.GenericTypeValidator")) : class$org$apache$commons$validator$GenericTypeValidator));
    static /* synthetic */ Class class$org$apache$commons$validator$GenericTypeValidator;

    public static Byte formatByte(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Byte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Short formatShort(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Short(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Integer formatInt(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long formatLong(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Float formatFloat(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double formatDouble(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Date formatDate(String string, Locale locale) {
        Date date = null;
        if (string == null) {
            return null;
        }
        try {
            DateFormat dateFormat = null;
            dateFormat = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
            dateFormat.setLenient(false);
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            log.warn((Object)string, (Throwable)parseException);
        }
        return date;
    }

    public static Date formatDate(String string, String string2, boolean bl) {
        Date date = null;
        if (string == null || string2 == null || string2.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setLenient(false);
            date = simpleDateFormat.parse(string);
            if (bl && string2.length() != string.length()) {
                date = null;
            }
        }
        catch (ParseException parseException) {
            log.warn((Object)string, (Throwable)parseException);
        }
        return date;
    }

    public static Long formatCreditCard(String string) {
        return GenericValidator.isCreditCard(string) ? new Long(string) : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

