/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.validator.CreditCardValidator;
import org.apache.commons.validator.DateValidator;
import org.apache.commons.validator.EmailValidator;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.oro.text.perl.Perl5Util;

public class GenericValidator
implements Serializable {
    public static final String REGEXP_DELIM = "/";
    private static final UrlValidator urlValidator = new UrlValidator();
    private static final CreditCardValidator creditCardValidator = new CreditCardValidator();

    public static boolean isBlankOrNull(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean matchRegexp(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            return false;
        }
        Perl5Util perl5Util = new Perl5Util();
        return perl5Util.match(REGEXP_DELIM + string2 + REGEXP_DELIM, string);
    }

    public static boolean isByte(String string) {
        return GenericTypeValidator.formatByte(string) != null;
    }

    public static boolean isShort(String string) {
        return GenericTypeValidator.formatShort(string) != null;
    }

    public static boolean isInt(String string) {
        return GenericTypeValidator.formatInt(string) != null;
    }

    public static boolean isLong(String string) {
        return GenericTypeValidator.formatLong(string) != null;
    }

    public static boolean isFloat(String string) {
        return GenericTypeValidator.formatFloat(string) != null;
    }

    public static boolean isDouble(String string) {
        return GenericTypeValidator.formatDouble(string) != null;
    }

    public static boolean isDate(String string, Locale locale) {
        return DateValidator.getInstance().isValid(string, locale);
    }

    public static boolean isDate(String string, String string2, boolean bl) {
        return DateValidator.getInstance().isValid(string, string2, bl);
    }

    public static boolean isInRange(byte by, byte by2, byte by3) {
        return by >= by2 && by <= by3;
    }

    public static boolean isInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static boolean isInRange(float f, float f2, float f3) {
        return f >= f2 && f <= f3;
    }

    public static boolean isInRange(short s, short s2, short s3) {
        return s >= s2 && s <= s3;
    }

    public static boolean isInRange(long l, long l2, long l3) {
        return l >= l2 && l <= l3;
    }

    public static boolean isInRange(double d, double d2, double d3) {
        return d >= d2 && d <= d3;
    }

    public static boolean isCreditCard(String string) {
        return creditCardValidator.isValid(string);
    }

    protected static boolean validateCreditCardLuhnCheck(String string) {
        return new CreditCardValidator().luhnCheck(string);
    }

    protected boolean validateCreditCardPrefixCheck(String string) {
        return new CreditCardValidator().isValidPrefix(string);
    }

    public static boolean isEmail(String string) {
        return EmailValidator.getInstance().isValid(string);
    }

    public static boolean isUrl(String string) {
        return urlValidator.isValid(string);
    }

    public static boolean maxLength(String string, int n) {
        return string.length() <= n;
    }

    public static boolean minLength(String string, int n) {
        return string.length() >= n;
    }

    protected static String getDelimittedRegexp(String string) {
        return ValidatorUtil.getDelimitedRegExp(string);
    }
}

