/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.util.Flags;
import org.apache.oro.text.perl.Perl5Util;

public class UrlValidator
implements Serializable {
    public static final int ALLOW_ALL_SCHEMES = 1;
    public static final int ALLOW_2_SLASHES = 2;
    public static final int NO_FRAGMENTS = 4;
    private static final String ALPHA_CHARS = "a-zA-Z";
    private static final String ALPHA_NUMERIC_CHARS = "a-zA-Z\\d";
    private static final String SPECIAL_CHARS = ";/@&=,.?:+$";
    private static final String VALID_CHARS = "[^\\s;/@&=,.?:+$]";
    private static final String SCHEME_CHARS = "a-zA-Z";
    private static final String AUTHORITY_CHARS = "a-zA-Z\\d\\-\\.";
    private static final String ATOM = "[^\\s;/@&=,.?:+$]+";
    private static final String URL_PATTERN = "/^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?/";
    private static final int PARSE_URL_SCHEME = 2;
    private static final int PARSE_URL_AUTHORITY = 4;
    private static final int PARSE_URL_PATH = 5;
    private static final int PARSE_URL_QUERY = 7;
    private static final int PARSE_URL_FRAGMENT = 9;
    private static final String SCHEME_PATTERN = "/^[a-zA-Z]/";
    private static final String AUTHORITY_PATTERN = "/^([a-zA-Z\\d\\-\\.]*)(:\\d*)?(.*)?/";
    private static final int PARSE_AUTHORITY_HOST_IP = 1;
    private static final int PARSE_AUTHORITY_PORT = 2;
    private static final int PARSE_AUTHORITY_EXTRA = 3;
    private static final String PATH_PATTERN = "/^(/[-a-zA-Z0-9_:@&?=+,.!/~*'%$]*)$/";
    private static final String QUERY_PATTERN = "/^(.*)$/";
    private static final String LEGAL_ASCII_PATTERN = "/^[\\000-\\177]+$/";
    private static final String IP_V4_DOMAIN_PATTERN = "/^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$/";
    private static final String DOMAIN_PATTERN = "/^[^\\s;/@&=,.?:+$]+(\\.[^\\s;/@&=,.?:+$]+)*$/";
    private static final String PORT_PATTERN = "/^:(\\d{1,5})$/";
    private static final String ATOM_PATTERN = "/([^\\s;/@&=,.?:+$]+)/";
    private static final String ALPHA_PATTERN = "/^[a-zA-Z]/";
    private Flags options = null;
    private Set allowedSchemes = new HashSet();
    protected String[] defaultSchemes = new String[]{"http", "https", "ftp"};

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] stringArray) {
        this(stringArray, 0);
    }

    public UrlValidator(int n) {
        this(null, n);
    }

    public UrlValidator(String[] stringArray, int n) {
        this.options = new Flags(n);
        if (this.options.isOn(1L)) {
            return;
        }
        if (stringArray == null) {
            stringArray = this.defaultSchemes;
        }
        this.allowedSchemes.addAll(Arrays.asList(stringArray));
    }

    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        Perl5Util perl5Util = new Perl5Util();
        Perl5Util perl5Util2 = new Perl5Util();
        if (!perl5Util2.match(LEGAL_ASCII_PATTERN, string)) {
            return false;
        }
        if (!perl5Util.match(URL_PATTERN, string)) {
            return false;
        }
        if (!this.isValidScheme(perl5Util.group(2))) {
            return false;
        }
        if (!this.isValidAuthority(perl5Util.group(4))) {
            return false;
        }
        if (!this.isValidPath(perl5Util.group(5))) {
            return false;
        }
        if (!this.isValidQuery(perl5Util.group(7))) {
            return false;
        }
        return this.isValidFragment(perl5Util.group(9));
    }

    protected boolean isValidScheme(String string) {
        if (string == null) {
            return false;
        }
        Perl5Util perl5Util = new Perl5Util();
        if (!perl5Util.match("/^[a-zA-Z]/", string)) {
            return false;
        }
        return !this.options.isOff(1L) || this.allowedSchemes.contains(string);
    }

    protected boolean isValidAuthority(String string) {
        Perl5Util perl5Util;
        if (string == null) {
            return false;
        }
        Perl5Util perl5Util2 = new Perl5Util();
        Perl5Util perl5Util3 = new Perl5Util();
        if (!perl5Util2.match(AUTHORITY_PATTERN, string)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = perl5Util2.group(1);
        bl = perl5Util3.match(IP_V4_DOMAIN_PATTERN, string2);
        if (bl) {
            for (int i = 1; i <= 4; ++i) {
                String string3 = perl5Util3.group(i);
                if (string3 == null || string3.length() <= 0) {
                    return false;
                }
                try {
                    if (Integer.parseInt(string3) <= 255) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        } else {
            Perl5Util perl5Util4 = new Perl5Util();
            bl2 = perl5Util4.match(DOMAIN_PATTERN, string2);
        }
        if (bl2) {
            String[] stringArray = new String[10];
            boolean bl3 = true;
            int n = 0;
            int n2 = 0;
            Perl5Util perl5Util5 = new Perl5Util();
            while (bl3) {
                bl3 = perl5Util5.match(ATOM_PATTERN, string2);
                if (!bl3) continue;
                stringArray[n] = perl5Util5.group(1);
                n2 = stringArray[n].length() + 1;
                string2 = n2 >= string2.length() ? "" : string2.substring(n2);
                ++n;
            }
            String string4 = stringArray[n - 1];
            if (string4.length() < 2 || string4.length() > 4) {
                return false;
            }
            Perl5Util perl5Util6 = new Perl5Util();
            if (!perl5Util6.match("/^[a-zA-Z]/", string4.substring(0, 1))) {
                return false;
            }
            if (n < 2) {
                return false;
            }
        }
        if (!bl2 && !bl) {
            return false;
        }
        String string5 = perl5Util2.group(2);
        if (string5 != null && !(perl5Util = new Perl5Util()).match(PORT_PATTERN, string5)) {
            return false;
        }
        String string6 = perl5Util2.group(3);
        return GenericValidator.isBlankOrNull(string6);
    }

    protected boolean isValidPath(String string) {
        if (string == null) {
            return false;
        }
        Perl5Util perl5Util = new Perl5Util();
        if (!perl5Util.match(PATH_PATTERN, string)) {
            return false;
        }
        if (string.endsWith("/")) {
            return false;
        }
        int n = this.countToken("//", string);
        if (this.options.isOff(2L) && n > 0) {
            return false;
        }
        int n2 = this.countToken("/", string);
        int n3 = this.countToken("..", string);
        return n3 <= 0 || n2 - n - 1 > n3;
    }

    protected boolean isValidQuery(String string) {
        if (string == null) {
            return true;
        }
        Perl5Util perl5Util = new Perl5Util();
        return perl5Util.match(QUERY_PATTERN, string);
    }

    protected boolean isValidFragment(String string) {
        if (string == null) {
            return true;
        }
        return this.options.isOff(4L);
    }

    protected int countToken(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            if ((n = string2.indexOf(string, n)) <= -1) continue;
            ++n;
            ++n2;
        }
        return n2;
    }
}

