/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResults;

public class Validator
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$Validator == null ? (class$org$apache$commons$validator$Validator = Validator.class$("org.apache.commons.validator.Validator")) : class$org$apache$commons$validator$Validator));
    public static final String BEAN_PARAM = "java.lang.Object";
    public static final String BEAN_KEY = "java.lang.Object";
    public static final String VALIDATOR_ACTION_PARAM = "org.apache.commons.validator.ValidatorAction";
    public static final String VALIDATOR_ACTION_KEY = "org.apache.commons.validator.ValidatorAction";
    public static final String FIELD_PARAM = "org.apache.commons.validator.Field";
    public static final String FIELD_KEY = "org.apache.commons.validator.Field";
    public static final String VALIDATOR_PARAM = "org.apache.commons.validator.Validator";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.Validator";
    public static final String LOCALE_PARAM = "java.util.Locale";
    public static final String LOCALE_KEY = "java.util.Locale";
    protected ValidatorResources resources = null;
    protected String formName = null;
    protected Map parameters = new HashMap();
    protected HashMap hResources = (HashMap)this.parameters;
    protected int page = 0;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    protected boolean onlyReturnErrors = false;
    static /* synthetic */ Class class$org$apache$commons$validator$Validator;

    public Validator(ValidatorResources validatorResources) {
        this(validatorResources, null);
    }

    public Validator(ValidatorResources validatorResources, String string) {
        if (validatorResources == null) {
            throw new IllegalArgumentException("Resources cannot be null.");
        }
        this.resources = validatorResources;
        this.formName = string;
    }

    public void addResource(String string, Object object) {
        this.setParameter(string, object);
    }

    public void setParameter(String string, Object object) {
        this.parameters.put(string, object);
    }

    public Object getResource(String string) {
        return this.getParameterValue(string);
    }

    public Object getParameterValue(String string) {
        return this.parameters.get(string);
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String string) {
        this.formName = string;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public void clear() {
        this.formName = null;
        this.parameters = new HashMap();
        this.hResources = (HashMap)this.parameters;
        this.page = 0;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean bl) {
        this.useContextClassLoader = bl;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ValidatorResults validate() throws ValidatorException {
        Locale locale = (Locale)this.getParameterValue("java.util.Locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setParameter("org.apache.commons.validator.Validator", this);
        Form form = this.resources.getForm(locale, this.formName);
        if (form != null) {
            return form.validate(this.parameters, this.resources.getValidatorActions(), this.page);
        }
        return new ValidatorResults();
    }

    public boolean getOnlyReturnErrors() {
        return this.onlyReturnErrors;
    }

    public void setOnlyReturnErrors(boolean bl) {
        this.onlyReturnErrors = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

