/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.util.ValidatorUtils;

public class ValidatorAction
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$ValidatorAction == null ? (class$org$apache$commons$validator$ValidatorAction = ValidatorAction.class$("org.apache.commons.validator.ValidatorAction")) : class$org$apache$commons$validator$ValidatorAction));
    private String name = null;
    private String classname = null;
    private Class validationClass = null;
    private String method = null;
    private Method validationMethod = null;
    private String methodParams = "java.lang.Object,org.apache.commons.validator.ValidatorAction,org.apache.commons.validator.Field";
    private Class[] parameterClasses = null;
    private String depends = null;
    private String msg = null;
    private String jsFunctionName = null;
    private String jsFunction = null;
    private String javascript = null;
    private Object instance = null;
    private List dependencyList = Collections.synchronizedList(new ArrayList());
    private List methodParameterList = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorAction;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(String string) {
        this.methodParams = string;
        this.methodParameterList.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.length() <= 0) continue;
            this.methodParameterList.add(string2);
        }
    }

    public List getMethodParamsList() {
        return Collections.unmodifiableList(this.methodParameterList);
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String string) {
        this.depends = string;
        this.dependencyList.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.length() <= 0) continue;
            this.dependencyList.add(string2);
        }
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public String getJsFunctionName() {
        return this.jsFunctionName;
    }

    public void setJsFunctionName(String string) {
        this.jsFunctionName = string;
    }

    public void setJsFunction(String string) {
        if (this.javascript != null) {
            throw new IllegalStateException("Cannot call setJsFunction() after calling setJavascript()");
        }
        this.jsFunction = string;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String string) {
        if (this.jsFunction != null) {
            throw new IllegalStateException("Cannot call setJavascript() after calling setJsFunction()");
        }
        this.javascript = string;
    }

    public Object getClassnameInstance() {
        return this.instance;
    }

    public void setClassnameInstance(Object object) {
        this.instance = object;
    }

    protected void init() {
        this.loadJavascriptFunction();
    }

    protected synchronized void loadJavascriptFunction() {
        if (this.javascriptAlreadyLoaded()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Loading function begun");
        }
        if (this.jsFunction == null) {
            this.jsFunction = this.generateJsFunction();
        }
        String string = this.formatJavascriptFileName();
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Loading js function '" + string + "'"));
        }
        this.javascript = this.readJavascriptFile(string);
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Loading javascript function completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readJavascriptFile(String string) {
        String string2;
        StringBuffer stringBuffer;
        block12: {
            InputStream inputStream;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((inputStream = classLoader.getResourceAsStream(string)) == null) {
                inputStream = this.getClass().getResourceAsStream(string);
            }
            if (inputStream == null) {
                log.debug((Object)("  Unable to read javascript name " + string));
                return null;
            }
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            Object var8_8 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                log.error((Object)"Error closing stream to javascript file.", (Throwable)iOException);
            }
            break block12;
            {
                catch (IOException iOException) {
                    log.error((Object)"Error reading javascript file.", (Throwable)iOException);
                    Object var8_9 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        log.error((Object)"Error closing stream to javascript file.", (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    log.error((Object)"Error closing stream to javascript file.", (Throwable)iOException);
                }
                throw throwable;
            }
        }
        string2 = stringBuffer.toString();
        return string2.equals("") ? null : string2;
    }

    private String formatJavascriptFileName() {
        String string = this.jsFunction.substring(1);
        if (!this.jsFunction.startsWith("/")) {
            string = this.jsFunction.replace('.', '/') + ".js";
        }
        return string;
    }

    private boolean javascriptAlreadyLoaded() {
        return this.javascript != null;
    }

    private String generateJsFunction() {
        StringBuffer stringBuffer = new StringBuffer("org.apache.commons.validator.javascript");
        stringBuffer.append(".validate");
        stringBuffer.append(this.name.substring(0, 1).toUpperCase());
        stringBuffer.append(this.name.substring(1, this.name.length()));
        return stringBuffer.toString();
    }

    public synchronized void process(Map map) {
    }

    public boolean isDependency(String string) {
        return this.dependencyList.contains(string);
    }

    public Collection getDependencies() {
        return this.getDependencyList();
    }

    public List getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ValidatorAction: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    boolean executeValidationMethod(Field field, Map map, ValidatorResults validatorResults, int n) throws ValidatorException {
        map.put("org.apache.commons.validator.ValidatorAction", this);
        try {
            Object object;
            block11: {
                ClassLoader classLoader = this.getClassLoader(map);
                this.loadValidationClass(classLoader);
                this.loadParameterClasses(classLoader);
                this.loadValidationMethod();
                Object[] objectArray = this.getParameterValues(map);
                if (field.isIndexed()) {
                    this.handleIndexedField(field, n, objectArray);
                }
                object = null;
                try {
                    object = this.validationMethod.invoke(this.getValidationClassInstance(), objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ValidatorException(illegalArgumentException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ValidatorException(illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof Exception) {
                        throw (Exception)invocationTargetException.getTargetException();
                    }
                    if (!(invocationTargetException.getTargetException() instanceof Error)) break block11;
                    throw (Error)invocationTargetException.getTargetException();
                }
            }
            boolean bl = this.isValid(object);
            if (!bl || bl && !this.onlyReturnErrors(map)) {
                validatorResults.add(field, this.name, bl, object);
            }
            if (!bl) {
                return false;
            }
        }
        catch (Exception exception) {
            if (exception instanceof ValidatorException) {
                throw (ValidatorException)exception;
            }
            log.error((Object)("Unhandled exception thrown during validation: " + exception.getMessage()), (Throwable)exception);
            validatorResults.add(field, this.name, false);
            return false;
        }
        return true;
    }

    private void loadValidationMethod() throws ValidatorException {
        if (this.validationMethod != null) {
            return;
        }
        try {
            this.validationMethod = this.validationClass.getMethod(this.method, this.parameterClasses);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ValidatorException(noSuchMethodException.getMessage());
        }
    }

    private void loadValidationClass(ClassLoader classLoader) throws ValidatorException {
        if (this.validationClass != null) {
            return;
        }
        try {
            this.validationClass = classLoader.loadClass(this.classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ValidatorException(classNotFoundException.getMessage());
        }
    }

    private void loadParameterClasses(ClassLoader classLoader) throws ValidatorException {
        if (this.parameterClasses != null) {
            return;
        }
        this.parameterClasses = new Class[this.methodParameterList.size()];
        for (int i = 0; i < this.methodParameterList.size(); ++i) {
            String string = (String)this.methodParameterList.get(i);
            try {
                this.parameterClasses[i] = classLoader.loadClass(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ValidatorException(classNotFoundException.getMessage());
            }
        }
    }

    private Object[] getParameterValues(Map map) {
        Object[] objectArray = new Object[this.methodParameterList.size()];
        for (int i = 0; i < this.methodParameterList.size(); ++i) {
            String string = (String)this.methodParameterList.get(i);
            objectArray[i] = map.get(string);
        }
        return objectArray;
    }

    private Object getValidationClassInstance() throws ValidatorException {
        if (Modifier.isStatic(this.validationMethod.getModifiers())) {
            this.instance = null;
        } else if (this.instance == null) {
            try {
                this.instance = this.validationClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                String string = "Couldn't create instance of " + this.classname + ".  " + instantiationException.getMessage();
                throw new ValidatorException(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string = "Couldn't create instance of " + this.classname + ".  " + illegalAccessException.getMessage();
                throw new ValidatorException(string);
            }
        }
        return this.instance;
    }

    private void handleIndexedField(Field field, int n, Object[] objectArray) throws ValidatorException {
        int n2 = this.methodParameterList.indexOf("java.lang.Object");
        int n3 = this.methodParameterList.indexOf("org.apache.commons.validator.Field");
        Object[] objectArray2 = field.getIndexedProperty(objectArray[n2]);
        objectArray[n2] = objectArray2[n];
        Field field2 = (Field)field.clone();
        field2.setKey(ValidatorUtils.replace(field2.getKey(), "[]", "[" + n + "]"));
        objectArray[n3] = field2;
    }

    private boolean isValid(Object object) {
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        return object != null;
    }

    private ClassLoader getClassLoader(Map map) {
        Validator validator = (Validator)map.get("org.apache.commons.validator.Validator");
        return validator.getClassLoader();
    }

    private boolean onlyReturnErrors(Map map) {
        Validator validator = (Validator)map.get("org.apache.commons.validator.Validator");
        return validator.getOnlyReturnErrors();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

