/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.xml.sax.SAXException;

public class ValidatorResources
implements Serializable {
    private static final String[] registrations = new String[]{"-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0//EN", "/org/apache/commons/validator/resources/validator_1_0.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0.1//EN", "/org/apache/commons/validator/resources/validator_1_0_1.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1//EN", "/org/apache/commons/validator/resources/validator_1_1.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1.3//EN", "/org/apache/commons/validator/resources/validator_1_1_3.dtd"};
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$ValidatorResources == null ? (class$org$apache$commons$validator$ValidatorResources = ValidatorResources.class$("org.apache.commons.validator.ValidatorResources")) : class$org$apache$commons$validator$ValidatorResources));
    protected FastHashMap hFormSets = new FastHashMap();
    protected FastHashMap hConstants = new FastHashMap();
    protected FastHashMap hActions = new FastHashMap();
    protected static Locale defaultLocale = Locale.getDefault();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorResources;

    public ValidatorResources() {
    }

    public ValidatorResources(InputStream inputStream) throws IOException, SAXException {
        this(new InputStream[]{inputStream});
    }

    public ValidatorResources(InputStream[] inputStreamArray) throws IOException, SAXException {
        int n;
        URL uRL = this.getClass().getResource("digester-rules.xml");
        Digester digester = DigesterLoader.createDigester((URL)uRL);
        digester.setNamespaceAware(true);
        digester.setValidating(true);
        digester.setUseContextClassLoader(true);
        for (n = 0; n < registrations.length; n += 2) {
            URL uRL2 = this.getClass().getResource(registrations[n + 1]);
            if (uRL2 == null) continue;
            digester.register(registrations[n], uRL2.toString());
        }
        for (n = 0; n < inputStreamArray.length; ++n) {
            digester.push((Object)this);
            digester.parse(inputStreamArray[n]);
        }
        this.process();
    }

    public void put(FormSet formSet) {
        this.addFormSet(formSet);
    }

    public void addFormSet(FormSet formSet) {
        String string = this.buildKey(formSet);
        ArrayList<FormSet> arrayList = (ArrayList<FormSet>)this.hFormSets.get((Object)string);
        if (arrayList == null) {
            arrayList = new ArrayList<FormSet>();
            this.hFormSets.put((Object)string, arrayList);
        }
        if (!arrayList.contains(formSet)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding FormSet '" + formSet.toString() + "'."));
            }
            arrayList.add(formSet);
        }
    }

    public void addConstant(Constant constant) {
        this.addConstantParam(constant.getName(), constant.getValue());
    }

    public void addConstantParam(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Global Constant: " + string + "," + string2));
            }
            this.hConstants.put((Object)string, (Object)string2);
        }
    }

    public void addConstant(String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Global Constant: " + string + "," + string2));
        }
        this.hConstants.put((Object)string, (Object)string2);
    }

    public void addValidatorAction(ValidatorAction validatorAction) {
        validatorAction.init();
        this.hActions.put((Object)validatorAction.getName(), (Object)validatorAction);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add ValidatorAction: " + validatorAction.getName() + "," + validatorAction.getClassname()));
        }
    }

    public ValidatorAction getValidatorAction(String string) {
        return (ValidatorAction)this.hActions.get((Object)string);
    }

    public Map getValidatorActions() {
        return Collections.unmodifiableMap(this.hActions);
    }

    protected String buildKey(FormSet formSet) {
        String string = this.buildLocale(formSet.getLanguage(), formSet.getCountry(), formSet.getVariant());
        if (string.length() == 0) {
            string = defaultLocale.toString();
        }
        return string;
    }

    private String buildLocale(String string, String string2, String string3) {
        String string4 = string != null && string.length() > 0 ? string : "";
        string4 = string4 + (string2 != null && string2.length() > 0 ? "_" + string2 : "");
        string4 = string4 + (string3 != null && string3.length() > 0 ? "_" + string3 : "");
        return string4;
    }

    public Form get(Locale locale, Object object) {
        String string = object == null ? null : object.toString();
        return this.getForm(locale, string);
    }

    public Form getForm(Locale locale, String string) {
        return this.getForm(locale.getLanguage(), locale.getCountry(), locale.getVariant(), string);
    }

    public Form get(String string, String string2, String string3, Object object) {
        String string4 = object == null ? null : object.toString();
        return this.getForm(string, string2, string3, string4);
    }

    public Form getForm(String string, String string2, String string3, String string4) {
        String string5 = this.buildLocale(string, string2, string3);
        List list = (List)this.hFormSets.get((Object)string5);
        if (list == null) {
            string5 = string != null && string.length() > 0 ? string : "";
            string5 = string5 + (string2 != null && string2.length() > 0 ? "_" + string2 : "");
            list = (List)this.hFormSets.get((Object)string5);
        }
        if (list == null) {
            string5 = string != null && string.length() > 0 ? string : "";
            list = (List)this.hFormSets.get((Object)string5);
        }
        if (list == null) {
            string5 = defaultLocale.toString();
            list = (List)this.hFormSets.get((Object)string5);
        }
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FormSet formSet = (FormSet)iterator.next();
            if (formSet == null || formSet.getForm(string4) == null) continue;
            return formSet.getForm(string4);
        }
        return null;
    }

    public void process() {
        this.hFormSets.setFast(true);
        this.hConstants.setFast(true);
        this.hActions.setFast(true);
        this.internalProcessForms();
    }

    public void processForms() {
        this.internalProcessForms();
    }

    private void internalProcessForms() {
        Object object;
        Object object2;
        Object object3;
        String string = defaultLocale.toString();
        Iterator iterator = this.hFormSets.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            if (((String)object3).equals(string)) continue;
            object2 = (List)this.hFormSets.get(object3);
            object = object2.iterator();
            while (object.hasNext()) {
                FormSet formSet = (FormSet)object.next();
                Iterator iterator2 = formSet.getForms().keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Form form = (Form)formSet.getForms().get(string2);
                    Form form2 = new Form();
                    form2.setName(form.getName());
                    Form form3 = this.get(defaultLocale, string2);
                    Iterator iterator3 = form3.getFields().iterator();
                    while (iterator3.hasNext()) {
                        Field field = (Field)iterator3.next();
                        String string3 = field.getKey();
                        if (form.containsField(string3)) {
                            form2.addField(form.getField(string3));
                            continue;
                        }
                        Field field2 = this.getClosestLocaleField(formSet, string2, string3);
                        form2.addField((Field)field2.clone());
                    }
                    formSet.addForm(form2);
                }
            }
        }
        iterator = this.hFormSets.values().iterator();
        while (iterator.hasNext()) {
            object3 = (List)iterator.next();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (FormSet)object2.next();
                if (((FormSet)object).isProcessed()) continue;
                ((FormSet)object).process((Map)this.hConstants);
            }
        }
    }

    protected Field getClosestLocaleField(FormSet formSet, String string, String string2) {
        Form form;
        Field field = null;
        String string3 = formSet.getLanguage();
        String string4 = formSet.getCountry();
        String string5 = formSet.getVariant();
        if (!(GenericValidator.isBlankOrNull(string3) || GenericValidator.isBlankOrNull(string4) || GenericValidator.isBlankOrNull(string5))) {
            form = this.getForm(string3, string4, string5, string);
            field = form.getField(string2);
        }
        if (field == null && !GenericValidator.isBlankOrNull(string3) && !GenericValidator.isBlankOrNull(string4)) {
            form = this.getForm(string3, string4, null, string);
            field = form.getField(string2);
        }
        if (field == null && !GenericValidator.isBlankOrNull(string3)) {
            form = this.getForm(string3, null, null, string);
            field = form.getField(string2);
        }
        if (field == null) {
            form = this.getForm(defaultLocale, string);
            field = form.getField(string2);
        }
        return field;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

