/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorResult;

public class ValidatorResults
implements Serializable {
    protected Map hResults = new HashMap();

    public void merge(ValidatorResults validatorResults) {
        this.hResults.putAll(validatorResults.hResults);
    }

    public void add(Field field, String string, boolean bl) {
        this.add(field, string, bl, null);
    }

    public void add(Field field, String string, boolean bl, Object object) {
        ValidatorResult validatorResult = this.getValidatorResult(field.getKey());
        if (validatorResult == null) {
            validatorResult = new ValidatorResult(field);
            this.hResults.put(field.getKey(), validatorResult);
        }
        validatorResult.add(string, bl, object);
    }

    public void clear() {
        this.hResults.clear();
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.hResults.isEmpty();
    }

    public ValidatorResult getValidatorResult(String string) {
        return (ValidatorResult)this.hResults.get(string);
    }

    public Iterator get() {
        if (this.hResults.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.hResults.keySet().iterator();
    }

    public Iterator properties() {
        return this.hResults.keySet().iterator();
    }

    public Set getPropertyNames() {
        return Collections.unmodifiableSet(this.hResults.keySet());
    }

    public Map getResultValueMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.hResults.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ValidatorResult validatorResult = this.getValidatorResult(string);
            Map map = validatorResult.getActionMap();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                String string2 = (String)iterator2.next();
                ValidatorResult.ResultStatus resultStatus = (ValidatorResult.ResultStatus)map.get(string2);
                if (resultStatus == null || (object = resultStatus.getResult()) == null || object instanceof Boolean) continue;
                hashMap.put(string, object);
            }
        }
        return hashMap;
    }
}

