/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.util;

import java.io.Serializable;

public class Flags
implements Serializable {
    private long flags = 0L;

    public Flags() {
    }

    public Flags(long l) {
        this.flags = l;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean isOn(long l) {
        return (this.flags & l) > 0L;
    }

    public boolean isOff(long l) {
        return (this.flags & l) == 0L;
    }

    public void turnOn(long l) {
        this.flags |= l;
    }

    public void turnOff(long l) {
        this.flags &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void turnOffAll() {
        this.flags = 0L;
    }

    public void clear() {
        this.flags = 0L;
    }

    public void turnOnAll() {
        this.flags = Long.MAX_VALUE;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Couldn't clone Flags object.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Flags)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Flags flags = (Flags)object;
        return this.flags == flags.flags;
    }

    public int hashCode() {
        return (int)this.flags;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Long.toBinaryString(this.flags));
        for (int i = 64 - stringBuffer.length(); i > 0; --i) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }
}

