/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.WildcardHelper;

public class ActionConfigMatcher
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$struts$config$ActionConfigMatcher == null ? (class$org$apache$struts$config$ActionConfigMatcher = ActionConfigMatcher.class$("org.apache.struts.config.ActionConfigMatcher")) : class$org$apache$struts$config$ActionConfigMatcher));
    private static final WildcardHelper wildcard = new WildcardHelper();
    private List compiledPaths = new ArrayList();
    static /* synthetic */ Class class$org$apache$struts$config$ActionConfigMatcher;

    public ActionConfigMatcher(ActionConfig[] actionConfigArray) {
        int n = 0;
        while (n < actionConfigArray.length) {
            String string = actionConfigArray[n].getPath();
            if (string != null && string.indexOf(42) > -1) {
                if (string.length() > 0 && string.charAt(0) == '/') {
                    string = string.substring(1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Compiling action config path '" + string + "'"));
                }
                int[] nArray = wildcard.compilePattern(string);
                this.compiledPaths.add(new Mapping(nArray, actionConfigArray[n]));
            }
            ++n;
        }
    }

    public ActionConfig match(String string) {
        ActionConfig actionConfig = null;
        if (this.compiledPaths.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to match '" + string + "' to a wildcard pattern"));
            }
            if (string.length() > 0 && string.charAt(0) == '/') {
                string = string.substring(1);
            }
            HashMap hashMap = new HashMap();
            Iterator iterator = this.compiledPaths.iterator();
            while (iterator.hasNext()) {
                Mapping mapping = (Mapping)iterator.next();
                if (!wildcard.match(hashMap, string, mapping.getPattern())) continue;
                actionConfig = this.convertActionConfig(string, mapping.getActionConfig(), hashMap);
            }
        }
        return actionConfig;
    }

    protected ActionConfig convertActionConfig(String string, ActionConfig actionConfig, Map map) {
        ActionConfig actionConfig2 = null;
        try {
            actionConfig2 = (ActionConfig)BeanUtils.cloneBean(actionConfig);
        }
        catch (Exception exception) {
            log.warn((Object)"Unable to clone action config, recommend not using wildcards", (Throwable)exception);
            return null;
        }
        actionConfig2.setName(this.convertParam(actionConfig.getName(), map));
        if (string.length() == 0 || string.charAt(0) != '/') {
            string = "/" + string;
        }
        actionConfig2.setPath(string);
        actionConfig2.setType(this.convertParam(actionConfig.getType(), map));
        actionConfig2.setRoles(this.convertParam(actionConfig.getRoles(), map));
        actionConfig2.setParameter(this.convertParam(actionConfig.getParameter(), map));
        actionConfig2.setAttribute(this.convertParam(actionConfig.getAttribute(), map));
        actionConfig2.setForward(this.convertParam(actionConfig.getForward(), map));
        actionConfig2.setInclude(this.convertParam(actionConfig.getInclude(), map));
        actionConfig2.setInput(this.convertParam(actionConfig.getInput(), map));
        ForwardConfig[] forwardConfigArray = actionConfig.findForwardConfigs();
        int n = 0;
        while (n < forwardConfigArray.length) {
            ActionForward actionForward = new ActionForward();
            actionForward.setContextRelative(forwardConfigArray[n].getContextRelative());
            actionForward.setName(forwardConfigArray[n].getName());
            actionForward.setPath(this.convertParam(forwardConfigArray[n].getPath(), map));
            actionForward.setRedirect(forwardConfigArray[n].getRedirect());
            actionConfig2.removeForwardConfig(forwardConfigArray[n]);
            actionConfig2.addForwardConfig(actionForward);
            ++n;
        }
        ExceptionConfig[] exceptionConfigArray = actionConfig.findExceptionConfigs();
        int n2 = 0;
        while (n2 < exceptionConfigArray.length) {
            actionConfig2.addExceptionConfig(exceptionConfigArray[n2]);
            ++n2;
        }
        actionConfig2.freeze();
        return actionConfig2;
    }

    protected String convertParam(String string, Map map) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("{") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("{0}");
        StringBuffer stringBuffer2 = new StringBuffer(string);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = iterator.next();
            stringBuffer.setCharAt(1, ((String)entry.getKey()).charAt(0));
            String string2 = stringBuffer.toString();
            while ((n = stringBuffer2.toString().indexOf(string2)) > -1) {
                stringBuffer2.replace(n, n + 3, (String)entry.getValue());
            }
        }
        return stringBuffer2.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Mapping
    implements Serializable {
        private int[] pattern;
        private ActionConfig config;

        public Mapping(int[] nArray, ActionConfig actionConfig) {
            this.pattern = nArray;
            this.config = actionConfig;
        }

        public int[] getPattern() {
            return this.pattern;
        }

        public ActionConfig getActionConfig() {
            return this.config;
        }
    }
}

