/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ConfigHelperInterface;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class ConfigHelper
implements ConfigHelperInterface {
    private ServletContext application = null;
    private HttpSession session = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ActionForward forward = null;

    public void setApplication(ServletContext servletContext) {
        this.application = servletContext;
    }

    public void setSession(HttpSession httpSession) {
        this.session = httpSession;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
        if (this.request == null) {
            this.setSession(null);
        } else {
            this.setSession(this.request.getSession());
        }
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
    }

    public void setForward(ActionForward actionForward) {
        this.forward = actionForward;
    }

    public void setResources(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.setApplication(servletContext);
        this.setRequest(httpServletRequest);
        this.setResponse(httpServletResponse);
    }

    public ConfigHelper() {
    }

    public ConfigHelper(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.setResources(servletContext, httpServletRequest, httpServletResponse);
    }

    public DataSource getDataSource() {
        if (this.application == null) {
            return null;
        }
        return (DataSource)this.application.getAttribute("org.apache.struts.action.DATA_SOURCE");
    }

    public ActionMessages getActionMessages() {
        if (this.application == null) {
            return null;
        }
        return (ActionMessages)this.application.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
    }

    public MessageResources getMessageResources() {
        if (this.application == null) {
            return null;
        }
        return (MessageResources)this.application.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public String getServletMapping() {
        if (this.application == null) {
            return null;
        }
        return (String)this.application.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    public String getToken() {
        if (this.session == null) {
            return null;
        }
        return (String)this.session.getAttribute("org.apache.struts.action.TOKEN");
    }

    public Throwable getException() {
        if (this.request == null) {
            return null;
        }
        return (Throwable)this.request.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    public MultipartRequestWrapper getMultipartRequestWrapper() {
        if (this.request == null) {
            return null;
        }
        return (MultipartRequestWrapper)this.request.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    public ActionMapping getMapping() {
        if (this.request == null) {
            return null;
        }
        return (ActionMapping)this.request.getAttribute("org.apache.struts.action.mapping.instance");
    }

    public boolean isMessage(String string) {
        MessageResources messageResources = this.getMessageResources();
        if (messageResources == null) {
            return false;
        }
        return messageResources.isPresent(RequestUtils.getUserLocale(this.request, null), string);
    }

    public ActionForm getActionForm() {
        ActionMapping actionMapping = this.getMapping();
        if (actionMapping == null) {
            return null;
        }
        String string = actionMapping.getAttribute();
        if (string == null) {
            return null;
        }
        ActionForm actionForm = null;
        actionForm = "request".equals(actionMapping.getScope()) ? (ActionForm)this.request.getAttribute(string) : (ActionForm)this.session.getAttribute(string);
        return actionForm;
    }

    public ActionFormBean getFormBean(String string) {
        return null;
    }

    public ActionForward getActionForward(String string) {
        return null;
    }

    public ActionMapping getActionMapping(String string) {
        return null;
    }

    public String getActionMappingName(String string) {
        String string2 = string;
        int n = string.indexOf("?");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        int n2 = string2.lastIndexOf("/");
        int n3 = string2.lastIndexOf(".");
        if (n3 >= 0 && n3 > n2) {
            string2 = string2.substring(0, n3);
        }
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/" + string2;
    }

    public String getActionMappingURL(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.request.getContextPath());
        String string2 = this.getServletMapping();
        if (string2 != null) {
            String string3 = null;
            int n = string.indexOf("?");
            if (n >= 0) {
                string3 = string.substring(n);
            }
            String string4 = this.getActionMappingName(string);
            if (string2.startsWith("*.")) {
                stringBuffer.append(string4);
                stringBuffer.append(string2.substring(1));
            } else if (string2.endsWith("/*")) {
                stringBuffer.append(string2.substring(0, string2.length() - 2));
                stringBuffer.append(string4);
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
        } else {
            if (!string.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getEncodeURL(String string) {
        if (this.session != null && this.response != null) {
            boolean bl = false;
            if (this.forward != null) {
                bl = this.forward.getRedirect();
            }
            if (bl) {
                return this.response.encodeRedirectURL(string);
            }
            return this.response.encodeURL(string);
        }
        return string;
    }

    public String getOrigRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer stringBuffer = RequestUtils.requestToServerUriStringBuffer(this.request);
        return stringBuffer.toString();
    }

    public String getBaseRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer stringBuffer = RequestUtils.requestToServerStringBuffer(this.request);
        String string = null;
        string = this.forward == null ? this.request.getRequestURI() : this.request.getContextPath() + this.forward.getPath();
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getLink(String string) {
        ActionForward actionForward = this.getActionForward(string);
        if (actionForward == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.request.getContextPath());
        stringBuffer.append(actionForward.getPath());
        return this.getEncodeURL(stringBuffer.toString());
    }

    public String getMessage(String string) {
        MessageResources messageResources = this.getMessageResources();
        if (messageResources == null) {
            return null;
        }
        return messageResources.getMessage(RequestUtils.getUserLocale(this.request, null), string);
    }

    public String getMessage(String string, Object[] objectArray) {
        MessageResources messageResources = this.getMessageResources();
        if (messageResources == null) {
            return null;
        }
        if (objectArray == null) {
            return messageResources.getMessage(RequestUtils.getUserLocale(this.request, null), string);
        }
        return messageResources.getMessage(RequestUtils.getUserLocale(this.request, null), string, objectArray);
    }

    public String getAction(String string) {
        return this.getEncodeURL(this.getActionMappingURL(string));
    }

    public String link(String string) {
        return this.getLink(string);
    }

    public String message(String string) {
        return this.getMessage(string);
    }

    public String message(String string, Object[] objectArray) {
        return this.getMessage(string, objectArray);
    }

    public String action(String string) {
        return this.getAction(string);
    }
}

