/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormPropertyConfig
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$struts$config$FormPropertyConfig == null ? (class$org$apache$struts$config$FormPropertyConfig = FormPropertyConfig.class$("org.apache.struts.config.FormPropertyConfig")) : class$org$apache$struts$config$FormPropertyConfig));
    protected boolean configured = false;
    protected String initial = null;
    protected String name = null;
    protected int size = 0;
    protected String type = null;
    static /* synthetic */ Class class$org$apache$struts$config$FormPropertyConfig;

    public FormPropertyConfig() {
    }

    public FormPropertyConfig(String string, String string2, String string3) {
        this(string, string2, string3, 0);
    }

    public FormPropertyConfig(String string, String string2, String string3, int n) {
        this.setName(string);
        this.setType(string2);
        this.setInitial(string3);
        this.setSize(n);
    }

    public String getInitial() {
        return this.initial;
    }

    public void setInitial(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.initial = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        if (n < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.size = n;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = string;
    }

    public Class getTypeClass() {
        String string = this.getType();
        boolean bl = false;
        if (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            bl = true;
        }
        Class<Comparable<Boolean>> clazz = null;
        if ("boolean".equals(string)) {
            clazz = Boolean.TYPE;
        } else if ("byte".equals(string)) {
            clazz = Byte.TYPE;
        } else if ("char".equals(string)) {
            clazz = Character.TYPE;
        } else if ("double".equals(string)) {
            clazz = Double.TYPE;
        } else if ("float".equals(string)) {
            clazz = Float.TYPE;
        } else if ("int".equals(string)) {
            clazz = Integer.TYPE;
        } else if ("long".equals(string)) {
            clazz = Long.TYPE;
        } else if ("short".equals(string)) {
            clazz = Short.TYPE;
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
        }
        if (bl) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    public Object initial() {
        Object object;
        block7: {
            object = null;
            try {
                Class clazz = this.getTypeClass();
                if (clazz.isArray()) {
                    if (this.initial != null) {
                        object = ConvertUtils.convert(this.initial, clazz);
                        break block7;
                    }
                    object = Array.newInstance(clazz.getComponentType(), this.size);
                    if (clazz.getComponentType().isPrimitive()) break block7;
                    int n = 0;
                    while (n < this.size) {
                        try {
                            Array.set(object, n, clazz.getComponentType().newInstance());
                        }
                        catch (Throwable throwable) {
                            log.error((Object)("Unable to create instance of " + clazz.getName() + " for property=" + this.name + ", type=" + this.type + ", initial=" + this.initial + ", size=" + this.size + "."));
                        }
                        ++n;
                    }
                    break block7;
                }
                object = this.initial != null ? ConvertUtils.convert(this.initial, clazz) : (Object)clazz.newInstance();
            }
            catch (Throwable throwable) {
                object = null;
            }
        }
        return object;
    }

    public void freeze() {
        this.configured = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FormPropertyConfig[");
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        stringBuffer.append(",type=");
        stringBuffer.append(this.type);
        stringBuffer.append(",initial=");
        stringBuffer.append(this.initial);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

