/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class ForwardTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.logic.LocalStrings");
    protected String name = null;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        ForwardConfig forwardConfig = null;
        ModuleConfig moduleConfig = TagUtils.getInstance().getModuleConfig(this.pageContext);
        if (moduleConfig != null) {
            forwardConfig = (ActionForward)moduleConfig.findForwardConfig(this.name);
        }
        if (forwardConfig == null) {
            JspException jspException = new JspException(messages.getMessage("forward.lookup", (Object)this.name));
            TagUtils.getInstance().saveException(this.pageContext, jspException);
            throw jspException;
        }
        String string = forwardConfig.getPath();
        string = moduleConfig.getPrefix() + string;
        if (forwardConfig.getRedirect()) {
            this.doRedirect(string);
        } else {
            this.doForward(string);
        }
        return 5;
    }

    protected void doForward(String string) throws JspException {
        try {
            this.pageContext.forward(string);
        }
        catch (Exception exception) {
            TagUtils.getInstance().saveException(this.pageContext, exception);
            throw new JspException(messages.getMessage("forward.forward", (Object)this.name, (Object)exception.toString()));
        }
    }

    protected void doRedirect(String string) throws JspException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        try {
            if (string.startsWith("/")) {
                string = httpServletRequest.getContextPath() + string;
            }
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string));
        }
        catch (Exception exception) {
            TagUtils.getInstance().saveException(this.pageContext, exception);
            throw new JspException(messages.getMessage("forward.redirect", (Object)this.name, (Object)exception.toString()));
        }
    }

    public void release() {
        super.release();
        this.name = null;
    }
}

