/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.TilesUtilStrutsImpl;
import org.apache.struts.tiles.TilesUtilStrutsModulesImpl;
import org.apache.struts.util.RequestUtils;

public class TilesPlugin
implements PlugIn {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$tiles$TilesPlugin == null ? (class$org$apache$struts$tiles$TilesPlugin = TilesPlugin.class$("org.apache.struts.tiles.TilesPlugin")) : class$org$apache$struts$tiles$TilesPlugin));
    protected boolean moduleAware = false;
    protected String tilesUtilImplClassname = null;
    protected DefinitionsFactory definitionFactory = null;
    protected PlugInConfig currentPlugInConfigObject = null;
    static /* synthetic */ Class class$org$apache$struts$tiles$TilesPlugin;
    static /* synthetic */ Class class$org$apache$struts$tiles$TilesUtilStrutsImpl;
    static /* synthetic */ Class class$org$apache$struts$tiles$TilesRequestProcessor;
    static /* synthetic */ Class class$org$apache$struts$action$RequestProcessor;

    public boolean isModuleAware() {
        return this.moduleAware;
    }

    public void setModuleAware(boolean bl) {
        this.moduleAware = bl;
    }

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        DefinitionsFactoryConfig definitionsFactoryConfig = this.readFactoryConfig(actionServlet, moduleConfig);
        definitionsFactoryConfig.setFactoryName(moduleConfig.getPrefix());
        this.initRequestProcessorClass(moduleConfig);
        this.initTilesUtil();
        this.initDefinitionsFactory(actionServlet.getServletContext(), moduleConfig, definitionsFactoryConfig);
    }

    private void initTilesUtil() throws ServletException {
        if (TilesUtil.isTilesUtilImplSet()) {
            return;
        }
        if (this.getTilesUtilImplClassname() == null) {
            if (this.isModuleAware()) {
                TilesUtil.setTilesUtil(new TilesUtilStrutsModulesImpl());
            } else {
                TilesUtil.setTilesUtil(new TilesUtilStrutsImpl());
            }
        } else {
            try {
                TilesUtilStrutsImpl tilesUtilStrutsImpl = (TilesUtilStrutsImpl)RequestUtils.applicationClass(this.getTilesUtilImplClassname()).newInstance();
                TilesUtil.setTilesUtil(tilesUtilStrutsImpl);
            }
            catch (ClassCastException classCastException) {
                throw new ServletException("Can't set TilesUtil implementation to '" + this.getTilesUtilImplClassname() + "'. TilesUtil implementation should be a subclass of '" + (class$org$apache$struts$tiles$TilesUtilStrutsImpl == null ? (class$org$apache$struts$tiles$TilesUtilStrutsImpl = TilesPlugin.class$("org.apache.struts.tiles.TilesUtilStrutsImpl")) : class$org$apache$struts$tiles$TilesUtilStrutsImpl).getName() + "'");
            }
            catch (Exception exception) {
                throw new ServletException("Can't set TilesUtil implementation.", (Throwable)exception);
            }
        }
    }

    private void initDefinitionsFactory(ServletContext servletContext, ModuleConfig moduleConfig, DefinitionsFactoryConfig definitionsFactoryConfig) throws ServletException {
        this.definitionFactory = ((TilesUtilStrutsImpl)TilesUtil.getTilesUtil()).getDefinitionsFactory(servletContext, moduleConfig);
        if (this.definitionFactory != null) {
            log.info((Object)("Factory already exists for module '" + moduleConfig.getPrefix() + "'. The factory found is from module '" + this.definitionFactory.getConfig().getFactoryName() + "'. No new creation."));
            return;
        }
        try {
            this.definitionFactory = TilesUtil.createDefinitionsFactory(servletContext, definitionsFactoryConfig);
        }
        catch (DefinitionsFactoryException definitionsFactoryException) {
            log.error((Object)("Can't create Tiles definition factory for module '" + moduleConfig.getPrefix() + "'."));
            throw new ServletException((Throwable)definitionsFactoryException);
        }
        log.info((Object)("Tiles definition factory loaded for module '" + moduleConfig.getPrefix() + "'."));
    }

    public void destroy() {
        this.definitionFactory.destroy();
        this.definitionFactory = null;
    }

    protected DefinitionsFactoryConfig readFactoryConfig(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        DefinitionsFactoryConfig definitionsFactoryConfig = new DefinitionsFactoryConfig();
        try {
            DefinitionsUtil.populateDefinitionsFactoryConfig(definitionsFactoryConfig, actionServlet.getServletConfig());
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)exception);
            }
            exception.printStackTrace();
            throw new UnavailableException("Can't populate DefinitionsFactoryConfig class from 'web.xml': " + exception.getMessage());
        }
        try {
            Map map = this.findStrutsPlugInConfigProperties(actionServlet, moduleConfig);
            definitionsFactoryConfig.populate(map);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)exception);
            }
            throw new UnavailableException("Can't populate DefinitionsFactoryConfig class from '" + moduleConfig.getPrefix() + "/struts-config.xml':" + exception.getMessage());
        }
        return definitionsFactoryConfig;
    }

    protected Map findStrutsPlugInConfigProperties(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        return this.currentPlugInConfigObject.getProperties();
    }

    protected void initRequestProcessorClass(ModuleConfig moduleConfig) throws ServletException {
        Class clazz;
        Class clazz2;
        String string = (class$org$apache$struts$tiles$TilesRequestProcessor == null ? (class$org$apache$struts$tiles$TilesRequestProcessor = TilesPlugin.class$("org.apache.struts.tiles.TilesRequestProcessor")) : class$org$apache$struts$tiles$TilesRequestProcessor).getName();
        ControllerConfig controllerConfig = moduleConfig.getControllerConfig();
        String string2 = controllerConfig.getProcessorClass();
        try {
            clazz2 = RequestUtils.applicationClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.fatal((Object)("Can't set TilesRequestProcessor: bad class name '" + string2 + "'."));
            throw new ServletException((Throwable)classNotFoundException);
        }
        if (string2.equals((class$org$apache$struts$action$RequestProcessor == null ? (class$org$apache$struts$action$RequestProcessor = TilesPlugin.class$("org.apache.struts.action.RequestProcessor")) : class$org$apache$struts$action$RequestProcessor).getName()) || string2.endsWith(string)) {
            controllerConfig.setProcessorClass(string);
            return;
        }
        Class clazz3 = clazz = class$org$apache$struts$tiles$TilesRequestProcessor == null ? (class$org$apache$struts$tiles$TilesRequestProcessor = TilesPlugin.class$("org.apache.struts.tiles.TilesRequestProcessor")) : class$org$apache$struts$tiles$TilesRequestProcessor;
        if (!clazz.isAssignableFrom(clazz2)) {
            String string3 = "TilesPlugin : Specified RequestProcessor not compatible with TilesRequestProcessor";
            if (log.isFatalEnabled()) {
                log.fatal((Object)string3);
            }
            throw new ServletException(string3);
        }
    }

    public void setTilesUtilImplClassname(String string) {
        this.tilesUtilImplClassname = string;
    }

    public String getTilesUtilImplClassname() {
        return this.tilesUtilImplClassname;
    }

    public void setCurrentPlugInConfigObject(PlugInConfig plugInConfig) {
        this.currentPlugInConfigObject = plugInConfig;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

