/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.struts.upload.ContentLengthExceededException;
import org.apache.struts.upload.MaxLengthExceededException;

public class BufferedMultipartInputStream
extends InputStream {
    protected InputStream inputStream;
    protected byte[] buffer;
    protected int bufferOffset = 0;
    protected int bufferSize = 8192;
    protected int bufferLength = 0;
    protected int totalLength = 0;
    protected long contentLength;
    protected long maxSize = -1L;
    protected boolean contentLengthMet = false;
    protected boolean maxLengthMet = false;

    public BufferedMultipartInputStream(InputStream inputStream, int n, long l, long l2) throws IOException {
        this.inputStream = inputStream;
        this.bufferSize = n;
        this.contentLength = l;
        this.maxSize = l2;
        if (l2 != -1L && l2 < l) {
            throw new MaxLengthExceededException(l2);
        }
        this.buffer = new byte[n];
        this.fill();
    }

    public int available() {
        return this.bufferLength - this.bufferOffset;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void mark(int n) {
        this.inputStream.mark(n);
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public boolean maxLengthMet() {
        return this.maxLengthMet;
    }

    public boolean contentLengthMet() {
        return this.contentLengthMet;
    }

    public int read() throws IOException {
        if (this.maxLengthMet) {
            throw new MaxLengthExceededException(this.maxSize);
        }
        if (this.contentLengthMet) {
            throw new ContentLengthExceededException(this.contentLength);
        }
        if (this.buffer == null) {
            return -1;
        }
        if (this.bufferOffset < this.bufferLength) {
            return (char)this.buffer[this.bufferOffset++];
        }
        this.fill();
        return this.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = 0;
        var5_5 = this.read();
        if (var5_5 != -1) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            var1_1[var2_2] = (byte)var5_5;
            var5_5 = this.read();
            ++var4_4;
            ++var2_2;
lbl9:
            // 2 sources

            ** while (var5_5 != -1 && var4_4 < var3_3)
        }
lbl10:
        // 1 sources

        return var4_4;
    }

    /*
     * Unable to fully structure code
     */
    public int readLine(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = 0;
        var5_5 = this.read();
        if (var5_5 != -1) ** GOTO lbl10
        return -1;
        while (var5_5 != 10) {
            var1_1[var2_2] = (byte)var5_5;
            ++var4_4;
            ++var2_2;
            var5_5 = this.read();
lbl10:
            // 2 sources

            if (var5_5 != -1 && var4_4 < var3_3) continue;
        }
        return var4_4;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] readLine() throws IOException {
        var1_1 = this.read();
        var2_2 = new ByteArrayOutputStream();
        if (-1 != var1_1) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2.write(var1_1);
            var1_1 = this.read();
lbl7:
            // 2 sources

            ** while (var1_1 != -1 && var1_1 != 10)
        }
lbl8:
        // 1 sources

        return var2_2.toByteArray();
    }

    public void reset() throws IOException {
        this.inputStream.reset();
    }

    protected void fill() throws IOException {
        if (this.bufferOffset > -1 && this.bufferLength > -1) {
            int n = Math.min(this.bufferSize, (int)this.contentLength + 1 - this.totalLength);
            if (n == 0) {
                this.contentLengthMet = true;
            }
            if (this.maxSize > -1L && n > 0 && (n = Math.min(n, (int)this.maxSize - this.totalLength)) == 0) {
                this.maxLengthMet = true;
            }
            int n2 = -1;
            if (n > 0) {
                n2 = this.inputStream.read(this.buffer, 0, n);
            }
            if (n2 == -1) {
                this.buffer = null;
                this.bufferOffset = -1;
                this.bufferLength = -1;
            } else {
                this.bufferLength = n2;
                this.totalLength += n2;
                this.bufferOffset = 0;
            }
        }
    }
}

