/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;

class MultipartValueStream
extends InputStream {
    public static final String HEADER_ENCODING = "iso-8859-1";
    private InputStream in;
    private byte[] boundaryBytes;
    private int matchedBoundaryBytes;
    private byte[] readAheadBytes;
    private int readAheadBufferStartI;
    private int readAheadBufferEndI;
    private boolean boundaryReached = false;
    private boolean finalBoundaryReached = false;

    public MultipartValueStream(InputStream inputStream, String string) throws IOException {
        this.in = inputStream;
        this.boundaryBytes = ("\r\n" + string).getBytes(HEADER_ENCODING);
        this.matchedBoundaryBytes = 0;
        this.readAheadBytes = new byte[this.boundaryBytes.length];
        if (inputStream.read(this.readAheadBytes, 0, this.readAheadBytes.length) != this.readAheadBytes.length) {
            throw new IOException("end of stream before boundary found!");
        }
        int n = 0;
        while (n < this.readAheadBytes.length) {
            if (this.readAheadBytes[n] == this.boundaryBytes[this.matchedBoundaryBytes]) {
                ++this.matchedBoundaryBytes;
            } else {
                this.matchedBoundaryBytes = 0;
                if (this.readAheadBytes[n] == this.boundaryBytes[0]) {
                    this.matchedBoundaryBytes = 1;
                }
            }
            ++n;
        }
        this.readAheadBufferStartI = 0;
        this.readAheadBufferEndI = this.readAheadBytes.length - 1;
    }

    public int read() throws IOException {
        int n;
        if (this.boundaryReached) {
            return -1;
        }
        if (this.matchedBoundaryBytes == this.boundaryBytes.length) {
            this.boundaryReached = true;
            byte[] byArray = new byte[2];
            if (this.in.read(byArray) != 2) {
                throw new IOException("end of stream before boundary found!");
            }
            String string = new String(byArray, HEADER_ENCODING);
            if (string.equals("--")) {
                if (this.in.read(byArray) != 2) {
                    throw new IOException("invalid end of final boundary found!");
                }
                string = new String(byArray, HEADER_ENCODING);
                if (!string.equals("\r\n")) {
                    throw new IOException("invalid end of final boundary found!");
                }
                this.finalBoundaryReached = true;
            } else if (string.equals("\r\n")) {
                this.finalBoundaryReached = false;
            } else {
                throw new IOException("invalid end of boundary found!");
            }
            return -1;
        }
        char c = (char)this.readAheadBytes[this.readAheadBufferStartI];
        ++this.readAheadBufferStartI;
        if (this.readAheadBufferStartI == this.readAheadBytes.length) {
            this.readAheadBufferStartI = 0;
        }
        if ((n = this.in.read()) == -1) {
            throw new IOException("end of stream before boundary found!");
        }
        ++this.readAheadBufferEndI;
        if (this.readAheadBufferEndI == this.readAheadBytes.length) {
            this.readAheadBufferEndI = 0;
        }
        this.readAheadBytes[this.readAheadBufferEndI] = (byte)n;
        if (this.readAheadBytes[this.readAheadBufferEndI] == this.boundaryBytes[this.matchedBoundaryBytes]) {
            ++this.matchedBoundaryBytes;
        } else {
            this.matchedBoundaryBytes = 0;
            if (this.readAheadBytes[this.readAheadBufferEndI] == this.boundaryBytes[0]) {
                this.matchedBoundaryBytes = 1;
            }
        }
        return c;
    }

    public boolean encounteredFinalBoundary() throws ServletException {
        if (!this.boundaryReached) {
            throw new ServletException("have not reached boundary yet!");
        }
        return this.finalBoundaryReached;
    }
}

