/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.Resources;

public class FieldChecks
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$struts$validator$FieldChecks == null ? (class$org$apache$struts$validator$FieldChecks = FieldChecks.class$("org.apache.struts.validator.FieldChecks")) : class$org$apache$struts$validator$FieldChecks));
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";
    static /* synthetic */ Class class$org$apache$struts$validator$FieldChecks;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean validateRequired(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
            return false;
        }
        return true;
    }

    public static boolean validateRequiredIf(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Object object2 = validator.getParameterValue("java.lang.Object");
        String string = null;
        boolean bl = false;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        int n = 0;
        String string2 = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            string2 = field.getVarValue("fieldJoin");
        }
        if (string2.equalsIgnoreCase("AND")) {
            bl = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + n + "]"))) {
            String string3;
            String string4 = field.getVarValue("field[" + n + "]");
            String string5 = field.getVarValue("fieldTest[" + n + "]");
            String string6 = field.getVarValue("fieldValue[" + n + "]");
            String string7 = field.getVarValue("fieldIndexed[" + n + "]");
            if (string7 == null) {
                string7 = "false";
            }
            String string8 = null;
            boolean bl2 = false;
            if (field.isIndexed() && string7.equalsIgnoreCase("true") && (string3 = field.getKey()).indexOf("[") > -1 && string3.indexOf("]") > -1) {
                String string9 = string3.substring(0, string3.indexOf(".") + 1);
                string4 = string9 + string4;
            }
            string8 = ValidatorUtils.getValueAsString((Object)object2, (String)string4);
            if (string5.equals(FIELD_TEST_NULL)) {
                bl2 = string8 == null || string8.length() <= 0;
            }
            if (string5.equals(FIELD_TEST_NOTNULL)) {
                bl2 = string8 != null && string8.length() > 0;
            }
            if (string5.equals(FIELD_TEST_EQUAL)) {
                bl2 = string6.equalsIgnoreCase(string8);
            }
            bl = string2.equalsIgnoreCase("AND") ? bl && bl2 : bl || bl2;
            ++n;
        }
        if (bl) {
            if (GenericValidator.isBlankOrNull((String)string)) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = field.getVarValue("mask");
        String string2 = null;
        string2 = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        try {
            if (!GenericValidator.isBlankOrNull((String)string2) && !GenericValidator.matchRegexp((String)string2, (String)string)) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return true;
        }
    }

    public static Object validateByte(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Byte by = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        by = GenericTypeValidator.formatByte((String)string);
        if (by == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return by == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)by;
    }

    public static Object validateShort(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Short s = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        s = GenericTypeValidator.formatShort((String)string);
        if (s == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return s == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)s;
    }

    public static Object validateInteger(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Integer n = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        n = GenericTypeValidator.formatInt((String)string);
        if (n == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return n == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)n;
    }

    public static Object validateLong(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Long l = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        l = GenericTypeValidator.formatLong((String)string);
        if (l == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return l == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)l;
    }

    public static Object validateFloat(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Float f = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        f = GenericTypeValidator.formatFloat((String)string);
        if (f == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return f == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)f;
    }

    public static Object validateDouble(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Double d = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        d = GenericTypeValidator.formatDouble((String)string);
        if (d == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return d == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)d;
    }

    public static Object validateDate(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Date date = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        String string2 = field.getVarValue("datePattern");
        String string3 = field.getVarValue("datePatternStrict");
        Locale locale = RequestUtils.getUserLocale(httpServletRequest, null);
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        try {
            date = string2 != null && string2.length() > 0 ? GenericTypeValidator.formatDate((String)string, (String)string2, (boolean)false) : (string3 != null && string3.length() > 0 ? GenericTypeValidator.formatDate((String)string, (String)string3, (boolean)true) : GenericTypeValidator.formatDate((String)string, (Locale)locale));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (date == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return date == null ? Boolean.FALSE : date;
    }

    public static boolean validateIntRange(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)string)) {
            try {
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(field.getVarValue("min"));
                int n3 = Integer.parseInt(field.getVarValue("max"));
                if (!GenericValidator.isInRange((int)n, (int)n2, (int)n3)) {
                    actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                    return false;
                }
            }
            catch (Exception exception) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateDoubleRange(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)string)) {
            try {
                double d = Double.parseDouble(string);
                double d2 = Double.parseDouble(field.getVarValue("min"));
                double d3 = Double.parseDouble(field.getVarValue("max"));
                if (!GenericValidator.isInRange((double)d, (double)d2, (double)d3)) {
                    actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                    return false;
                }
            }
            catch (Exception exception) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateFloatRange(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)string)) {
            try {
                float f = Float.parseFloat(string);
                float f2 = Float.parseFloat(field.getVarValue("min"));
                float f3 = Float.parseFloat(field.getVarValue("max"));
                if (!GenericValidator.isInRange((float)f, (float)f2, (float)f3)) {
                    actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                    return false;
                }
            }
            catch (Exception exception) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
        }
        return true;
    }

    public static Object validateCreditCard(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        Long l = null;
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string)) {
            return Boolean.TRUE;
        }
        l = GenericTypeValidator.formatCreditCard((String)string);
        if (l == null) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        }
        return l == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)l;
    }

    public static boolean validateEmail(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)string) && !GenericValidator.isEmail((String)string)) {
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (string != null) {
            try {
                int n = Integer.parseInt(field.getVarValue("maxlength"));
                if (!GenericValidator.maxLength((String)string, (int)n)) {
                    actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                    return false;
                }
            }
            catch (Exception exception) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        String string = null;
        string = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)string)) {
            try {
                int n = Integer.parseInt(field.getVarValue("minlength"));
                if (!GenericValidator.minLength((String)string, (int)n)) {
                    actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                    return false;
                }
            }
            catch (Exception exception) {
                actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateUrl(Object object, ValidatorAction validatorAction, Field field, ActionMessages actionMessages, Validator validator, HttpServletRequest httpServletRequest) {
        StringTokenizer stringTokenizer;
        String string;
        int n;
        String string2 = null;
        string2 = FieldChecks.isString(object) ? (String)object : ValidatorUtils.getValueAsString((Object)object, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)string2)) {
            return true;
        }
        boolean bl = "true".equalsIgnoreCase(field.getVarValue("allowallschemes"));
        int n2 = n = bl ? 1 : 0;
        if ("true".equalsIgnoreCase(field.getVarValue("allow2slashes"))) {
            n += 2;
        }
        if ("true".equalsIgnoreCase(field.getVarValue("nofragments"))) {
            n += 4;
        }
        String string3 = string = bl ? null : field.getVarValue("schemes");
        if (n == 0 && string == null) {
            if (GenericValidator.isUrl((String)string2)) {
                return true;
            }
            actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
            return false;
        }
        String[] stringArray = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n3++] = stringTokenizer.nextToken().trim();
            }
        }
        if ((stringTokenizer = new UrlValidator(stringArray, n)).isValid(string2)) {
            return true;
        }
        actionMessages.add(field.getKey(), Resources.getActionMessage(validator, httpServletRequest, validatorAction, field));
        return false;
    }

    protected static boolean isString(Object object) {
        return object == null ? true : (class$java$lang$String == null ? (class$java$lang$String = FieldChecks.class$("java.lang.String")) : class$java$lang$String).isInstance(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

