/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins.strategies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.plugins.PluginException;
import org.apache.commons.digester.plugins.RuleLoader;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public class LoaderFromStream
extends RuleLoader {
    private byte[] input;
    private FromXmlRuleSet ruleSet;

    public LoaderFromStream(InputStream inputStream) throws Exception {
        this.load(inputStream);
    }

    private void load(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.input = byteArrayOutputStream.toByteArray();
    }

    public void addRules(Digester digester, String string) throws PluginException {
        Log log = digester.getLogger();
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)("LoaderFromStream: loading rules for plugin at path [" + string + "]"));
        }
        InputSource inputSource = new InputSource(new ByteArrayInputStream(this.input));
        FromXmlRuleSet fromXmlRuleSet = new FromXmlRuleSet(inputSource);
        fromXmlRuleSet.addRuleInstances(digester, string);
    }
}

