/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.xmlrules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.BeanPropertySetterRule;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.CallParamRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.FactoryCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectParamRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.digester.SetPropertyRule;
import org.apache.commons.digester.SetRootRule;
import org.apache.commons.digester.SetTopRule;
import org.apache.commons.digester.xmlrules.CircularIncludeException;
import org.apache.commons.digester.xmlrules.DigesterRulesSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DigesterRuleParser
extends RuleSetBase {
    public static final String DIGESTER_PUBLIC_ID = "-//Jakarta Apache //DTD digester-rules XML V1.0//EN";
    private String digesterDtdUrl;
    protected Digester targetDigester;
    protected String basePath = "";
    protected PatternStack patternStack;
    private Set includedFiles = new HashSet();
    static /* synthetic */ Class class$org$apache$commons$digester$Rule;

    public DigesterRuleParser() {
        this.patternStack = new PatternStack();
    }

    public DigesterRuleParser(Digester digester) {
        this.targetDigester = digester;
        this.patternStack = new PatternStack();
    }

    private DigesterRuleParser(Digester digester, PatternStack patternStack, Set set) {
        this.targetDigester = digester;
        this.patternStack = patternStack;
        this.includedFiles = set;
    }

    public void setTarget(Digester digester) {
        this.targetDigester = digester;
    }

    public void setBasePath(String string) {
        this.basePath = string == null ? "" : (string.length() > 0 && !string.endsWith("/") ? string + "/" : string);
    }

    public void setDigesterRulesDTD(String string) {
        this.digesterDtdUrl = string;
    }

    protected String getDigesterRulesDTD() {
        return this.digesterDtdUrl;
    }

    public void add(Rule rule) {
        this.targetDigester.addRule(this.basePath + this.patternStack.toString(), rule);
    }

    public void addRuleInstances(Digester digester) {
        String string = (class$org$apache$commons$digester$Rule == null ? (class$org$apache$commons$digester$Rule = DigesterRuleParser.class$("org.apache.commons.digester.Rule")) : class$org$apache$commons$digester$Rule).getName();
        digester.register(DIGESTER_PUBLIC_ID, this.getDigesterRulesDTD());
        digester.addRule("*/pattern", new PatternRule("value"));
        digester.addRule("*/include", new IncludeRule());
        digester.addFactoryCreate("*/bean-property-setter-rule", new BeanPropertySetterRuleFactory());
        digester.addRule("*/bean-property-setter-rule", new PatternRule("pattern"));
        digester.addSetNext("*/bean-property-setter-rule", "add", string);
        digester.addFactoryCreate("*/call-method-rule", new CallMethodRuleFactory());
        digester.addRule("*/call-method-rule", new PatternRule("pattern"));
        digester.addSetNext("*/call-method-rule", "add", string);
        digester.addFactoryCreate("*/object-param-rule", new ObjectParamRuleFactory());
        digester.addRule("*/object-param-rule", new PatternRule("pattern"));
        digester.addSetNext("*/object-param-rule", "add", string);
        digester.addFactoryCreate("*/call-param-rule", new CallParamRuleFactory());
        digester.addRule("*/call-param-rule", new PatternRule("pattern"));
        digester.addSetNext("*/call-param-rule", "add", string);
        digester.addFactoryCreate("*/factory-create-rule", new FactoryCreateRuleFactory());
        digester.addRule("*/factory-create-rule", new PatternRule("pattern"));
        digester.addSetNext("*/factory-create-rule", "add", string);
        digester.addFactoryCreate("*/object-create-rule", new ObjectCreateRuleFactory());
        digester.addRule("*/object-create-rule", new PatternRule("pattern"));
        digester.addSetNext("*/object-create-rule", "add", string);
        digester.addFactoryCreate("*/set-properties-rule", new SetPropertiesRuleFactory());
        digester.addRule("*/set-properties-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-properties-rule", "add", string);
        digester.addRule("*/set-properties-rule/alias", new SetPropertiesAliasRule());
        digester.addFactoryCreate("*/set-property-rule", new SetPropertyRuleFactory());
        digester.addRule("*/set-property-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-property-rule", "add", string);
        digester.addFactoryCreate("*/set-top-rule", new SetTopRuleFactory());
        digester.addRule("*/set-top-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-top-rule", "add", string);
        digester.addFactoryCreate("*/set-next-rule", new SetNextRuleFactory());
        digester.addRule("*/set-next-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-next-rule", "add", string);
        digester.addFactoryCreate("*/set-root-rule", new SetRootRuleFactory());
        digester.addRule("*/set-root-rule", new PatternRule("pattern"));
        digester.addSetNext("*/set-root-rule", "add", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BeanPropertySetterRuleFactory
    extends AbstractObjectCreationFactory {
        private BeanPropertySetterRuleFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            BeanPropertySetterRule beanPropertySetterRule = null;
            String string = attributes.getValue("propertyname");
            beanPropertySetterRule = string == null ? new BeanPropertySetterRule() : new BeanPropertySetterRule(string);
            return beanPropertySetterRule;
        }
    }

    protected class CallMethodRuleFactory
    extends AbstractObjectCreationFactory {
        protected CallMethodRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            CallMethodRule callMethodRule = null;
            String string = attributes.getValue("methodname");
            if (attributes.getValue("paramcount") == null) {
                callMethodRule = new CallMethodRule(string);
            } else {
                int n = Integer.parseInt(attributes.getValue("paramcount"));
                String string2 = attributes.getValue("paramtypes");
                if (string2 == null || string2.length() == 0) {
                    callMethodRule = new CallMethodRule(string, n);
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r,");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    callMethodRule = new CallMethodRule(string, n, arrayList.toArray(new String[0]));
                }
            }
            return callMethodRule;
        }
    }

    protected class CallParamRuleFactory
    extends AbstractObjectCreationFactory {
        protected CallParamRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("paramnumber"));
            String string = attributes.getValue("attrname");
            String string2 = attributes.getValue("from-stack");
            CallParamRule callParamRule = null;
            if (string == null) {
                callParamRule = string2 == null ? new CallParamRule(n) : new CallParamRule(n, Boolean.valueOf(string2));
            } else if (string2 == null) {
                callParamRule = new CallParamRule(n, string);
            } else {
                throw new RuntimeException("Attributes from-stack and attrname cannot both be present.");
            }
            return callParamRule;
        }
    }

    protected class FactoryCreateRuleFactory
    extends AbstractObjectCreationFactory {
        protected FactoryCreateRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("classname");
            String string2 = attributes.getValue("attrname");
            boolean bl = "true".equalsIgnoreCase(attributes.getValue("ignore-exceptions"));
            return string2 == null || string2.length() == 0 ? new FactoryCreateRule(string, bl) : new FactoryCreateRule(string, string2, bl);
        }
    }

    private class IncludeRule
    extends Rule {
        public void begin(Attributes attributes) throws Exception {
            String string;
            String string2 = attributes.getValue("path");
            if (string2 != null && string2.length() > 0) {
                this.includeXMLRules(string2);
            }
            if ((string = attributes.getValue("class")) != null && string.length() > 0) {
                this.includeProgrammaticRules(string);
            }
        }

        private void includeXMLRules(String string) throws IOException, SAXException, CircularIncludeException {
            URL uRL;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = DigesterRuleParser.this.getClass().getClassLoader();
            }
            if ((uRL = classLoader.getResource(string)) == null) {
                throw new FileNotFoundException("File \"" + string + "\" not found.");
            }
            string = uRL.toExternalForm();
            if (!DigesterRuleParser.this.includedFiles.add(string)) {
                throw new CircularIncludeException(string);
            }
            DigesterRuleParser digesterRuleParser = new DigesterRuleParser(DigesterRuleParser.this.targetDigester, DigesterRuleParser.this.patternStack, DigesterRuleParser.this.includedFiles);
            digesterRuleParser.setDigesterRulesDTD(DigesterRuleParser.this.getDigesterRulesDTD());
            Digester digester = new Digester();
            digester.addRuleSet(digesterRuleParser);
            digester.push(DigesterRuleParser.this);
            digester.parse(string);
            DigesterRuleParser.this.includedFiles.remove(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void includeProgrammaticRules(String string) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
            Class<?> clazz = Class.forName(string);
            DigesterRulesSource digesterRulesSource = (DigesterRulesSource)clazz.newInstance();
            Rules rules = DigesterRuleParser.this.targetDigester.getRules();
            RulesPrefixAdapter rulesPrefixAdapter = new RulesPrefixAdapter(DigesterRuleParser.this.patternStack.toString(), rules);
            DigesterRuleParser.this.targetDigester.setRules(rulesPrefixAdapter);
            try {
                digesterRulesSource.getRules(DigesterRuleParser.this.targetDigester);
                Object var7_6 = null;
                DigesterRuleParser.this.targetDigester.setRules(rules);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                DigesterRuleParser.this.targetDigester.setRules(rules);
                throw throwable;
            }
        }
    }

    protected class ObjectCreateRuleFactory
    extends AbstractObjectCreationFactory {
        protected ObjectCreateRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("classname");
            String string2 = attributes.getValue("attrname");
            return string2 == null || string2.length() == 0 ? new ObjectCreateRule(string) : new ObjectCreateRule(string, string2);
        }
    }

    protected class ObjectParamRuleFactory
    extends AbstractObjectCreationFactory {
        protected ObjectParamRuleFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            int n = Integer.parseInt(attributes.getValue("paramnumber"));
            String string = attributes.getValue("attrname");
            String string2 = attributes.getValue("type");
            String string3 = attributes.getValue("value");
            ObjectParamRule objectParamRule = null;
            if (string2 == null) {
                throw new RuntimeException("Attribute 'type' is required.");
            }
            Object object = null;
            Class<?> clazz = Class.forName(string2);
            object = string3 == null ? (Object)clazz.newInstance() : ConvertUtils.convert((String)string3, clazz);
            objectParamRule = string == null ? new ObjectParamRule(n, object) : new ObjectParamRule(n, string, object);
            return objectParamRule;
        }
    }

    private class PatternRule
    extends Rule {
        private String attrName;
        private String pattern = null;

        public PatternRule(String string) {
            this.attrName = string;
        }

        public void begin(Attributes attributes) {
            this.pattern = attributes.getValue(this.attrName);
            if (this.pattern != null) {
                DigesterRuleParser.this.patternStack.push(this.pattern);
            }
        }

        public void end() {
            if (this.pattern != null) {
                DigesterRuleParser.this.patternStack.pop();
            }
        }
    }

    protected class PatternStack
    extends ArrayStack {
        protected PatternStack() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.size()) {
                String string = this.get(n).toString();
                if (string.length() > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('/');
                    }
                    stringBuffer.append(string);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    private class RulesPrefixAdapter
    implements Rules {
        private Rules delegate;
        private String prefix;

        public RulesPrefixAdapter(String string, Rules rules) {
            this.prefix = string;
            this.delegate = rules;
        }

        public void add(String string, Rule rule) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.prefix);
            if (!string.startsWith("/")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
            this.delegate.add(stringBuffer.toString(), rule);
        }

        public void clear() {
            this.delegate.clear();
        }

        public Digester getDigester() {
            return this.delegate.getDigester();
        }

        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        public List match(String string) {
            return this.delegate.match(string);
        }

        public List match(String string, String string2) {
            return this.delegate.match(string, string2);
        }

        public List rules() {
            return this.delegate.rules();
        }

        public void setDigester(Digester digester) {
            this.delegate.setDigester(digester);
        }

        public void setNamespaceURI(String string) {
            this.delegate.setNamespaceURI(string);
        }
    }

    protected class SetNextRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetNextRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("methodname");
            String string2 = attributes.getValue("paramtype");
            return string2 == null || string2.length() == 0 ? new SetNextRule(string) : new SetNextRule(string, string2);
        }
    }

    protected class SetPropertiesAliasRule
    extends Rule {
        public void begin(Attributes attributes) {
            String string = attributes.getValue("attr-name");
            String string2 = attributes.getValue("prop-name");
            SetPropertiesRule setPropertiesRule = (SetPropertiesRule)this.digester.peek();
            setPropertiesRule.addAlias(string, string2);
        }
    }

    protected class SetPropertiesRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetPropertiesRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            return new SetPropertiesRule();
        }
    }

    protected class SetPropertyRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetPropertyRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("value");
            return new SetPropertyRule(string, string2);
        }
    }

    protected class SetRootRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetRootRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("methodname");
            String string2 = attributes.getValue("paramtype");
            return string2 == null || string2.length() == 0 ? new SetRootRule(string) : new SetRootRule(string, string2);
        }
    }

    protected class SetTopRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetTopRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String string = attributes.getValue("methodname");
            String string2 = attributes.getValue("paramtype");
            return string2 == null || string2.length() == 0 ? new SetTopRule(string) : new SetTopRule(string, string2);
        }
    }
}

