package com.tarena.oss.admin.service;

import java.sql.Date;
import java.util.Collection;

import com.mchange.v2.async.StrandedTaskReporting;
import com.tarena.oss.admin.dao.AdminMgmtDAO;
import com.tarena.oss.admin.pojo.Admin;
import com.tarena.oss.admin.pojo.AdminCondDTO;

public class AdminMgmtServiceImpl implements AdminMgmtService {
	private AdminMgmtDAO dao;
	
	public void setDao(AdminMgmtDAO dao) {
		this.dao = dao;
	}

	public Admin lgoin(String userName, String password) {
		return dao.validate(userName, password);
	}

	public void addAdmin(Admin a) {
		dao.insertAdmin(a);
		
	}

	public Collection<Admin> findAdmin() {
		return dao.queryadmins();
	}

	public Admin findAdmin(Integer id) {
		return dao.queryadmin(id);
	}

	public void modifyAdmin(Admin a) {
		dao.updateAdmin(a);
		
	}

	public void removeAdmin(Admin a) {
		dao.deleteAdmin(a);
		
	}

	public Collection<Admin> findAdmin(AdminCondDTO dto) {
		StringBuffer sb=new StringBuffer();
		String name=dto.getName();
		String loginname=dto.getLoginname();
		String  starttime=dto.getStarttime();
		String  endtime=dto.getEndtime();
		if(name!=null && !name.trim().equals(""))
			sb.append(" and a.name like '%").append(name).append("%'");
		if(loginname!=null && !loginname.trim().equals(""))
			sb.append(" and a.loginname like '%").append(loginname).append("%'");
//		if(starttime!=null && endtime!=null) sb.append(" and a.");
		if (starttime!=null && !starttime.trim().equals("")) sb.append(" and a.enrolldate>= '").append(starttime).append("'");
		if(endtime!=null && !endtime.trim().equals("")) sb.append(" and a.enrolldate<= '").append(endtime).append("'");
		System.out.println(sb.toString()+"==Ȩ==");
		return dao.queryadmins(sb.toString());
	}

	public Collection<Admin> findAdmin(AdminCondDTO dto, int currentPage) {
		String qryStr = makeQryString(dto);
		return dao.queryadmins(qryStr, currentPage);
	}
	private String makeQryString(AdminCondDTO dto){
		StringBuffer sb = new StringBuffer();
		String name = dto.getName();
		String loginname=dto.getLoginname();
		if (name != null && !name.trim().equals(""))
			sb.append(" and a.name like '%").append(name).append("%'");
		if(loginname!=null && !loginname.trim().equals(""))
			sb.append(" and a.loginname like '%").append(loginname).append("%'");
		return sb.toString();
	}

	public int findAdminCntsByCond(AdminCondDTO dto) {
		String qryStr = makeQryString(dto);
		return dao.queryPricingCnt(qryStr);
	}
}
