package com.tarena.oss.dms;

import com.tarena.oss.selfservice.pojo.BaseHibernateDAO;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.criterion.Example;

/**
 * Data access object (DAO) for domain model class Detailmonths.
 * 
 * @see com.tarena.oss.Detailmonths
 * @author MyEclipse Persistence Tools
 */

public class DetailmonthsDAO extends BaseHibernateDAO {
	private static final Log log = LogFactory.getLog(DetailmonthsDAO.class);

	// property constants
	public static final String DURATION = "duration";

	public void save(Detailmonths transientInstance) {
		log.debug("saving Detailmonths instance");
		try {
			getSession().save(transientInstance);
			log.debug("save successful");
		} catch (RuntimeException re) {
			log.error("save failed", re);
			throw re;
		}
	}

	public void delete(Detailmonths persistentInstance) {
		log.debug("deleting Detailmonths instance");
		try {
			getSession().delete(persistentInstance);
			log.debug("delete successful");
		} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

	public Detailmonths findById(DetailmonthsId id) {
		log.debug("getting Detailmonths instance with id: " + id);
		try {
			Detailmonths instance = (Detailmonths) getSession().get(
					"com.tarena.oss.Detailmonths", id);
			return instance;
		} catch (RuntimeException re) {
			log.error("get failed", re);
			throw re;
		}
	}

	public List findByExample(Detailmonths instance) {
		log.debug("finding Detailmonths instance by example");
		try {
			List results = getSession().createCriteria(
					"com.tarena.oss.Detailmonths")
					.add(Example.create(instance)).list();
			log.debug("find by example successful, result size: "
					+ results.size());
			return results;
		} catch (RuntimeException re) {
			log.error("find by example failed", re);
			throw re;
		}
	}

	public List findByProperty(String propertyName, Object value) {
		log.debug("finding Detailmonths instance with property: "
				+ propertyName + ", value: " + value);
		try {
			String queryString = "from Detailmonths as model where model."
					+ propertyName + "= ?";
			Query queryObject = getSession().createQuery(queryString);
			queryObject.setParameter(0, value);
			return queryObject.list();
		} catch (RuntimeException re) {
			log.error("find by property name failed", re);
			throw re;
		}
	}

	public List findByDuration(Object duration) {
		return findByProperty(DURATION, duration);
	}

	public List findAll() {
		log.debug("finding all Detailmonths instances");
		try {
			String queryString = "from Detailmonths";
			Query queryObject = getSession().createQuery(queryString);
			return queryObject.list();
		} catch (RuntimeException re) {
			log.error("find all failed", re);
			throw re;
		}
	}

	public Detailmonths merge(Detailmonths detachedInstance) {
		log.debug("merging Detailmonths instance");
		try {
			Detailmonths result = (Detailmonths) getSession().merge(
					detachedInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}

	public void attachDirty(Detailmonths instance) {
		log.debug("attaching dirty Detailmonths instance");
		try {
			getSession().saveOrUpdate(instance);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void attachClean(Detailmonths instance) {
		log.debug("attaching clean Detailmonths instance");
		try {
			getSession().lock(instance, LockMode.NONE);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}
}