package com.tarena.oss.pricing.dao;

import java.util.Collection;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.tarena.oss.pricing.pojo.Pricing;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PricingMgmtDAOTest extends TestCase {
	private ApplicationContext context;
	private PricingMgmtDAO dao;
	public PricingMgmtDAOTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		context =new ClassPathXmlApplicationContext("applicationContext.xml");
		dao=(PricingMgmtDAO)context.getBean("pricingDAO");
	}

	protected void tearDown() throws Exception {
		context=null;
		dao=null;
	}

	public void testInsertPricing() {
		Pricing p=new Pricing(null,"ʷ",5,1,"ͨJUnit");
		dao.insertPricing(p);
		Pricing p1=new Pricing(null,"ʷһ",4,1,"ͨJUnit");
		dao.insertPricing(p1);
	}

	public void testUpdatePricing() {
		Pricing p=new Pricing(1,"testmoney",5.5,1.1,"tongguoJUnit");
		dao.updatePricing(p);
	}

	public void testDeletePricing() {
//		Pricing p3=new Pricing(1,"ʷ",5,1,"ͨJUnit");
//		dao.deletePricing(p3);
		Pricing p4=new Pricing(3,"",0,0,"");
		dao.deletePricing(p4);
	}

	public void testQueryPricings() {
		Collection<Pricing> ps1=dao.queryPricings();
	}

	public void testQueryPricingsString() {
		Collection<Pricing> ps=dao.queryPricings("and p.baseFee<=6");
//		this.assertEquals(2, ps.size());
		System.out.println(ps);
	}

	public void testQueryPricing() {
		Pricing p=dao.queryPricing(1);
		System.out.println(p);
	}

	public static Test suite(){
		TestSuite suite=new TestSuite();
		suite.addTest(new PricingMgmtDAOTest("testDeletePricing"));
		return suite;
	}
}
