package com.tarena.oss.pricing.service;

import java.util.Collection;

import com.tarena.oss.pricing.dao.PricingMgmtDAO;
import com.tarena.oss.pricing.pojo.Pricing;
import com.tarena.oss.pricing.pojo.PricingCondDTO;

public class PricingMgmtServiceImpl implements PricingMgmtService {
	private PricingMgmtDAO dao;
	
	public void setDao(PricingMgmtDAO dao) {
		this.dao = dao;
	}

	public void addPricing(Pricing p) {
		dao.insertPricing(p);

	}

	public Pricing findPricing(Integer id) {
		return dao.queryPricing(id);
	}

	public Collection<Pricing> findPricings() {
		return dao.queryPricings();
	}

	public Collection<Pricing> findPricings(PricingCondDTO dto) {
		StringBuffer sb=new StringBuffer();
		String name=dto.getName();
		double lbfee=dto.getLowerBaseFee();
		double ubfee=dto.getUpperBaseFee();
		double lrfee=dto.getLowerRateFee();
		double urfee=dto.getUpperRateFee();
		if(name!=null && !name.trim().equals(""))
			sb.append("and p.name like'%").append(name).append("%'");
		if(lbfee!=0.0 &&ubfee!=0.0 )
			sb.append("and p.baerFee between ").append(lbfee).append(" and ");
		else if(lbfee!=0.0) sb.append(" and p.baseFee >= ").append(lbfee);
		else if(ubfee!=0.0) sb.append(" and p.baseFee <= ").append(ubfee);
		
		if(lrfee!=0.0 &&urfee!=0.0 )
			sb.append("and p.rateFee between ").append(lrfee).append(" and ");
		else if(lrfee!=0.0) sb.append(" and p.rateFee >= ").append(lrfee);
		else if(urfee!=0.0) sb.append(" and p.rateFee <= ").append(urfee);
		System.out.println(sb.toString()+"....................................");
		return dao.queryPricings(sb.toString());
	}

	public void modifyPricing(Pricing p) {
		dao.updatePricing(p);

	}

	public void removePricing(Pricing p) {
		dao.deletePricing(p);

	}

	public int findPricingCnts() {
		// TODO Auto-generated method stub
		return 0;
	}

	public int findPricingCntsByCond(PricingCondDTO dto) {
		String qryStr = makeQryString(dto);
		return dao.queryPricingCnt(qryStr);
	}

	public Collection<Pricing> findPricings(int currentPage) {
		// TODO Auto-generated method stub
		return null;
	}

	public Collection<Pricing> findPricings(PricingCondDTO dto, int currentPage) {
		String qryStr = makeQryString(dto);
		return dao.queryPricings(qryStr, currentPage);
	}
	private String makeQryString(PricingCondDTO dto){
		StringBuffer sb = new StringBuffer();
		String name = dto.getName();
		double lbfee = dto.getLowerBaseFee();
		double ubfee = dto.getUpperBaseFee();
		double lrfee = dto.getLowerRateFee();
		double urfee = dto.getUpperRateFee();
		
		if (name != null && !name.trim().equals(""))
			sb.append(" and p.name like '%").append(name).append("%'");
		
		if (lbfee != 0.0 && ubfee != 0.0)
			sb.append(" and p.baseFee between ").append(lbfee).append(" and ").append(ubfee);
		else if (lbfee != 0.0)
			sb.append(" and p.baseFee >= ").append(lbfee);
		else if (ubfee != 0.0)
			sb.append(" and p.baseFee <= ").append(ubfee);
		
		if (lrfee != 0.0 && urfee != 0.0)
			sb.append(" and p.rateFee between ").append(lrfee).append(" and ").append(urfee);
		else if (lrfee != 0.0)
			sb.append(" and p.rateFee >= ").append(lrfee);
		else if (urfee != 0.0)
			sb.append(" and p.rateFee <= ").append(urfee);
		
		return sb.toString();
	}

}
