package com.tarena.oss.pricing.service;

import java.util.Collection;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.tarena.oss.pricing.dao.PricingMgmtDAO;
import com.tarena.oss.pricing.dao.PricingMgmtDAOTest;
import com.tarena.oss.pricing.pojo.Pricing;
import com.tarena.oss.pricing.pojo.PricingCondDTO;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PricingMgmtServiceTest extends TestCase {
	private ApplicationContext context;
	private PricingMgmtService dao;
	public PricingMgmtServiceTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		context =new ClassPathXmlApplicationContext("applicationContext.xml");
		dao=(PricingMgmtService)context.getBean("pricingService");
	}

	protected void tearDown() throws Exception {
		context=null;
		dao=null;
	}

	public void testAddPricing() {
		Pricing p = new Pricing(null, "test", 1, 1, "test by junit");
		dao.addPricing(p);
	}

	public void testModifyPricing() {
		Pricing p=new Pricing(1,"ʷѹ1",0.1,0.1,"service ");
		dao.modifyPricing(p);
	}

	public void testRemovePricing() {
		Pricing p=new Pricing(14,"",0,0,"");
		dao.removePricing(p);
	}

	public void testFindPricings() {
		Collection<Pricing> p=dao.findPricings();
	}

	public void testFindPricingsPricingCondDTO() {
		PricingCondDTO dto=new PricingCondDTO();
		dto.setLowerBaseFee(3);
		Collection<Pricing> ps=dao.findPricings(dto);
		System.out.println(ps);
	}

	public void testFindPricing() {
		Integer id=1;
		Pricing p=dao.findPricing(id);
		System.out.println(p);
	}
	public static Test suite(){
		TestSuite suite=new TestSuite();
		suite.addTest(new PricingMgmtServiceTest("testFindPricingsPricingCondDTO"));
		return suite;
	}

}
