package com.tarena.oss.rights.service;

import java.util.Collection;

import com.tarena.oss.rights.dao.RightsMgmtDAO;
import com.tarena.oss.rights.pojo.Module;
import com.tarena.oss.rights.pojo.Operation;
import com.tarena.oss.rights.pojo.Rights;
import com.tarena.oss.rights.pojo.RightsCondDTO;

public class RigthsMgmtServiceImpl implements RightsMgmtService {
	private RightsMgmtDAO rightdao;
	public void setRightdao(RightsMgmtDAO rightdao) {
		this.rightdao = rightdao;
	}
	
	public void addRight(Rights r) {
		rightdao.insertRights(r);
	}

	public Rights findRight(Integer id) {
		return rightdao.queryRight(id);
	}

	public int findRightCnts() {
		return rightdao.queryRightCnt();
	}

	public int findRightCntsByCond(RightsCondDTO dto) {
		return rightdao.queryRightCnt(makeString(dto));
	}

	public Collection<Rights> findRights(int currentPage) {
		return rightdao.queryRights(currentPage);
	}

	public Collection<Rights> findRights(RightsCondDTO dto, int currentPage) {
		return rightdao.queryRights(makeString(dto), currentPage);
	}

	public void modifyRight(Rights r) {
		rightdao.updateRights(r);
	}

	public void removeRight(Integer id) {
		rightdao.deleteRights(rightdao.queryRight(id));
	}
	private String makeString(RightsCondDTO dto){
		return null;
	}

	public Operation findOperation(Integer id) {
		return rightdao.queryOperation(id);
	}

	public Collection<Rights> findRights() {
		return rightdao.queryRights();
	}

	public Collection<Module> findmodules() {
		return rightdao.queryModules();
	}

	public Collection<Operation> findOperation() {
		return rightdao.queryOperation();
	}
}
