package com.tarena.oss.rights.service;

import java.util.Collection;

import com.tarena.oss.rights.dao.RoleMgmtDAO;
import com.tarena.oss.rights.pojo.Role;
import com.tarena.oss.rights.pojo.RoleCondDTO;

public class RoleMgmtServiceImpl implements RoleMgmtService {
	private RoleMgmtDAO roledao;

	public void setRoledao(RoleMgmtDAO roledao) {
		this.roledao = roledao;
	}
	public void addRolet(Role r) {
		roledao.insertRote(r);
	}

	public Role findRole(Integer id) {
		return roledao.queryRole(id);
	}

	public int findRoleCnts() {
		return roledao.queryRoleCnt();
	}

	public int findRoleCntsByCond(RoleCondDTO dto) {
		return roledao.queryRoleCnt(makeString(dto));
	}

	public Collection<Role> findRoles(int currentPage) {
		return roledao.queryRole(currentPage);
	}

	public Collection<Role> findRoles(RoleCondDTO dto, int currentPage) {
		return roledao.queryRole(makeString(dto), currentPage);
	}

	public void modifyRole(Role r) {
		roledao.updateRole(r);
	}

	public void removeRole(Integer id) {
		roledao.deleteRole(roledao.queryRole(id));
	}
	private String makeString(RoleCondDTO dto){
		return null;
	}

}
