package com.tarena.oss.user.dao;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.tarena.oss.user.pojo.User;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class UserMgmtDAOHibernateTest extends TestCase {
	//springעApplicationContext
	private ApplicationContext context;
	private UserMgmtDAO dao;
	
	public void setDao(UserMgmtDAO dao) {
		this.dao = dao;
	}

	public UserMgmtDAOHibernateTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		context=new ClassPathXmlApplicationContext("applicationContext.xml");
		dao=(UserMgmtDAO) context.getBean("userDAO");
	}

	protected void tearDown() throws Exception {
		context=null;
		dao=null;
	}

	public void testDeleteUser() {
		User user =dao.queryUser(1);
		dao.deleteUser(user);
	}

	public void testInsertUser(){
		short s = 1;
		//Timestamp t = new Timestamp(61164566665000l);
		Date t1= new Date(2009-02-02);
		User user = new User(null,"eric1","eric1","eric1",0,t1,1,s);
		dao.insertUser(user);
	}

	public void testUpdateUser() {
		User u=dao.queryUser(9);
		Date d = new Date(2009-02-02);
		u.setEnrolldate(d);
		dao.updateUser(u);
		System.out.println(u);
	}

	public void testQueryUser() {
		dao.queryUsers();
	}

	public void testQueryUsers() {
		Collection c =dao.queryUsers();
		System.out.println(c);
	}

	public void testQueryUsersString() {
		Collection c=dao.queryUsers(" and u.name like '%eric%' ");
		System.out.println(c);
	}

	public void testQueryUsersInt() {
		User u=dao.queryUser(1);
		System.out.println(u);
	}

	public void testQueryUsersStringInt() {
		Collection c = dao.queryUsers("", 1);
		System.out.println(c);
	}

	public void testQueryUserCnt() {
		int t=dao.queryUserCnt();
		System.out.println(t);
	}

	public void testQueryUserCntString() {
		int t=dao.queryUserCnt(" and u.name like '%eric%' ");
		System.out.println(t);
	}
	
	public void testLogin(){
		dao.login("bill", "188272");
	}
	public static Test suite(){
		TestSuite suite = new TestSuite();
//		suite.addTest(new UserMgmtDAOHibernateTest("testInsertUser"));
//		suite.addTest(new UserMgmtDAOHibernateTest("testQueryUsersInt"));
//		suite.addTest(new UserMgmtDAOHibernateTest("testDeleteUser"));
		suite.addTest(new UserMgmtDAOHibernateTest("testLogin"));
//		suite.addTest(new UserMgmtDAOHibernateTest("testQueryUsers"));
//		suite.addTest(new UserMgmtDAOHibernateTest("testQueryUserCnt"));
//		suite.addTest(new UserMgmtDAOHibernateTest("testQueryUserCntString"));
//		suite.addTest(new UserMgmtDAOHibernateTest("testQueryUsersString"));
		return suite;
	}

}
