package com.tarena.oss.user.service;

import java.util.Collection;

import com.tarena.oss.user.dao.UserMgmtDAO;
import com.tarena.oss.user.pojo.User;
import com.tarena.oss.user.pojo.UserCondDTO;

public class UserMgmtServiceImpl implements UserMgmtService {
	private UserMgmtDAO dao;
	
	public void setDao(UserMgmtDAO dao) {
		this.dao = dao;
	}

	/**
	 * idɾû
	 */
	public void removeUser(Integer id) {
		User user =dao.queryUser(id);
		dao.deleteUser(user);
	}

	/**
	 * û
	 */
	public void addUser(User user) {
		dao.insertUser(user);
	}

	/**
	 * ޸û
	 */
	public void modifyUser(User user) {
		dao.updateUser(user);	
	}

	/**
	 * idѯûϸϢ
	 */
	public User findUser(Integer id) {
		return dao.queryUser(id);
	}

	/**
	 * ѯûĵĸ
	 */
	public int findUserCnts() {
		return dao.queryUserCnt();
	}

	/**
	 * ݲѯѯûĸ
	 */
	public int findUserCntsByCond(UserCondDTO dto) {
		String qryStr = makeQryString(dto);
		return dao.queryUserCnt(qryStr);
	}

	/**
	 * ѯûϸϢ
	 */
	public Collection<User> findUsers() {
		return dao.queryUsers();
	}

	/**
	 * ݲѯѯûϸϢ
	 */
	public Collection<User> findUsers(UserCondDTO dto) {
		String qryStr = makeQryString(dto);
		System.out.println("sql :"+qryStr);
		return dao.queryUsers(qryStr);
	}

	/**
	 * ݵǰҳѯûϸϢ
	 */
	public Collection<User> findUsers(int currentPage) {
		return dao.queryUsers(currentPage);
	}

	/**
	 * ݲѯ͵ǰҳѯûϸϢ
	 */
	public Collection<User> findUsers(UserCondDTO dto,int currentPage) {
		String qryStr = makeQryString(dto);
		return dao.queryUsers(qryStr, currentPage);
	}

	/**
	 * ƴӲѯ
	 */
	public String makeQryString(UserCondDTO dto){
		StringBuffer sb = new StringBuffer();
		String name =dto.getName();
		String loginname =dto.getLoginname();
		String status=dto.getStatus()+"";
		
		if(name != null && !name.trim().equals("")){
			sb.append(" and u.name like '%").append(name).append("%'");
		}
		
		if(loginname !=null && !loginname.trim().equals("")){
			sb.append(" and u.loginname like '%").append(loginname).append("%'");
		}
		
		if(status!=null && !status.trim().equals("")){
			if(status.equals("-1")){
				sb.append("and u.status in(0 , 1)");
			}else{
				sb.append(" and u.status = ").append(status);
			}
			
		}

		System.out.println("makeQryString :"+sb.toString());
		return sb.toString();
		
	}

	public User login(String userName, String password) {
		// TODO Auto-generated method stub
		return dao.login(userName, password);
	}

	public User queryUserByLoginname(Integer id) {
		// TODO Auto-generated method stub
		return dao.queryUserByLoginname(id);
	}


}
