package com.tarena.oss.userservice.service;

import java.util.Collection;

import com.tarena.oss.userservice.dao.UserServiceMgmtDAO;
import com.tarena.oss.userservice.pojo.UserService;
import com.tarena.oss.userservice.pojo.UserServiceCondDTO;

public class UserServiceMgmtServiceImpl implements UserServiceMgmtService {
	private UserServiceMgmtDAO dao;
	
	public void setDao(UserServiceMgmtDAO dao) {
		this.dao = dao;
	}
	
	/**
	 * һҵʺ
	 */
	public void addUserService(UserService userservice) {
		dao.insertUserService(userservice);
	}
	
	/**
	 * ޸һҵʺ
	 */
	public void modifyUserService(UserService userservice) {
		dao.updateUserService(userservice);
	}

	/**
	 * ɾһҵʺ
	 */
	public void removeUserService(Integer id) {
		UserService us=dao.queryUserService(id);
		dao.deleteUserService(us);
	}
	
	/**
	 * idһҵʺ
	 */
	public UserService findUserService(Integer id) {
		return dao.queryUserService(id);
	}

	/**
	 * еҵʺ
	 */
	public Collection<UserService> findUserServices() {
		return dao.queryUserServices();
	}

	/**
	 * ݲѯһ߶ҵʺ
	 */
	public Collection<UserService> findUserServices(UserServiceCondDTO dto) {
		String str =this.makeQryString(dto);
		System.out.println("sql :"+str);
		return dao.queryUserServices(str);
	}

	/**
	 * ݵǰҳһ߶ҵʺ
	 */
	public Collection<UserService> findUserServices(int currentPage) {
		return dao.queryUserServices(currentPage);
	}

	/**
	 * ݵǰҳͲѯһ߶ҵʺ
	 */
	public Collection<UserService> findUserServices(UserServiceCondDTO dto,int currentPage) {
		String str =makeQryString(dto);
		System.out.println("sql: "+str);
		return dao.queryUserServices(str, currentPage);
	}

	/**
	 * ѯҵʺŵ
	 */
	public int findUserServiceCnts() {
		return dao.queryUserServiceCnt();
	}
	
	/**
	 * ݲѯҷҵʺŵ
	 */
	public int findUserServicesByCond(UserServiceCondDTO dto) {
		String str = makeQryString(dto);
		return dao.queryUserServiceCnt(str);
	}
	
	/**
	 * ƴӲѯ
	 */
	public String makeQryString(UserServiceCondDTO dto){
		StringBuffer sb = new StringBuffer();
		String loginname=dto.getLoginname();
		String labip =dto.getLabip();
		String status =dto.getStatus()+"";
		String username=dto.getUsername();
		
		if(username!=null && !username.trim().equals("")){
			sb.append(" and us.user.name like '%").append(username).append("%'");
		}
		
		if(loginname !=null && !loginname.trim().equals("")){
			sb.append(" and us.loginname like '%").append(loginname).append("%'");
		}
		
		if(labip !=null && !labip.trim().equals("")){
			sb.append(" and us.labip like '%").append(labip).append("%'");
		}
		
		if(status!=null && !status.trim().equals("")){
			if(status.equals("-1")){
				sb.append(" and us.status in(0 , 1)");
			}else{
				sb.append(" and us.status = ").append(status);
			}
			
		}
		
		System.out.println("makeQryString :"+sb.toString());
		
		return sb.toString();
	}
	

}
