package com.tarena.oss.web.actions;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.account.pojo.Detaildays;
import com.tarena.oss.account.pojo.Detailmonths;
import com.tarena.oss.account.pojo.Detailyears;
import com.tarena.oss.account.service.AccountMgmtService;
import com.tarena.oss.admin.pojo.Admin;

import com.tarena.oss.rights.pojo.Rights;
import com.tarena.oss.util.RightsTools;

public class AccountAction extends MappingDispatchAction {
	AccountMgmtService service;
	
	
	public void setService(AccountMgmtService service) {
		this.service = service;
	}

	public ActionForward listRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Admin admin = (Admin) request.getSession().getAttribute("ADMIN");
		Integer mid = Integer.valueOf(request.getParameter("mid"));
		
		Set<Rights> rs = RightsTools.getRights(admin, mid);
		request.getSession().setAttribute("MODULE_RIGHTS", rs);
		
		return mapping.findForward("success");
	}
	
	public ActionForward toqryacctyear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Collection<Detailyears> dy=service.findAccountByYear();
		request.setAttribute("Detailyears", dy);
		return mapping.findForward("success");
	}
	
	public ActionForward acctyeardetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String labip=request.getParameter("labip");
		String year=request.getParameter("longTime");
		Collection<Detailmonths> dm=service.findAccountByMonth(labip,year);
		request.setAttribute("Detailmonths", dm);
		return mapping.findForward("success");
	}
	 public ActionForward acctyear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		 String year=request.getParameter("year");
		 Collection<Detailyears> dy=service.findAccountByYear(year);
		request.setAttribute("Detailyears", dy);
		return mapping.findForward("success");
		}
	 
	 public ActionForward toqryacctmonth(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		 	Collection<Detailmonths> dm=service.findAccountByMonth();
		 	request.setAttribute("Detailmonths", dm);
			return mapping.findForward("success");
		}
	 public ActionForward acctmonthdetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		 String labip=request.getParameter("labip");
		 String year=request.getParameter("longTime");
		 String month=request.getParameter("monthTime");
		 Collection<Detaildays> dd=service.findAccountByDate(labip,year,month);
		 request.setAttribute("Detaildays", dd);
		return mapping.findForward("success");
		}
	
	 public ActionForward  acctmonth(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		 String year=request.getParameter("year");
		 String month=request.getParameter("month");
		 Collection<Detailmonths> dm=service.findAccountByMonthfor(year, month);
		 request.setAttribute("Detailmonths", dm);
		return mapping.findForward("success");
		}
	 
}
