package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.admin.pojo.Admin;
import com.tarena.oss.admin.pojo.AdminCondDTO;
import com.tarena.oss.admin.service.AdminMgmtService;
import com.tarena.oss.pricing.pojo.PricingCondDTO;
import com.tarena.oss.rights.pojo.Rights;
import com.tarena.oss.rights.pojo.Role;
import com.tarena.oss.util.PageParameter;
import com.tarena.oss.util.RightsTools;
import com.tarena.oss.web.forms.AdminCondForm;
import com.tarena.oss.web.forms.AdminForm;


public class AdminAction extends MappingDispatchAction {
	private AdminMgmtService service;
	
	public void setService(AdminMgmtService service) {
		this.service = service;
	}

	public ActionForward listRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Admin admin = (Admin) request.getSession().getAttribute("ADMIN");
		System.out.println(admin+"==Աadmin==");
		Integer mid = Integer.valueOf(request.getParameter("mid"));
		System.out.println(mid+"==Աmid==");
		Set<Rights> rs = RightsTools.getRights(admin, mid);
		request.getSession().setAttribute("MODULE_RIGHTS", rs);
		
		return mapping.findForward("success");
	}
	
	public ActionForward listAdmins(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
//		õǰҳ
		int currentPage = 0;
		String page = request.getParameter("page");
		if (page==null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
//		ѯ
		Collection<Admin> ac=service.findAdmin(new AdminCondDTO(),currentPage);
		System.out.println(ac+"===ѯ==");
		request.setAttribute("ADMINCALL", ac);
		
//		 ҳ
		int totalPages = 0;
		int totalRows = service.findAdminCntsByCond(new AdminCondDTO());
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
//		 ÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		// contextPath
		url.append(request.getContextPath());
		System.out.println(url+"===contextPath===");
		// servletPath
		url.append(request.getServletPath());
		System.out.println(url+"===servletPath===");
		// еĲ
		url.append("?");
		System.out.println(url+"===?===");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
					System.out.println(url+"=====for===");
				}
			}
		}
//		 ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		System.out.println(pagenav);
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		String type = request.getParameter("type");
		if (type.equals("1"))
			return mapping.findForward("list");
		else if (type.equals("2"))
			return mapping.findForward("listforupd");
		else
			return mapping.findForward("listfordel");
	}

	public ActionForward addAdmin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Role role1=new Role();
		Set<Role> set=new HashSet<Role>();
		AdminForm aform=(AdminForm) form;
		Admin a=aform.getA();
		System.out.println(a+"==ӵa==");
		String[] role=aform.getRole();
		System.out.println(role.length+"==role.length==");
		for(int i=0;i<role.length;i++){
			Integer j=Integer.parseInt(role[i]);
			System.out.println(role[i]+"===roles[x]===");
			role1.setId(j);
			set.add(role1);
			a.setRoles(set);
		}
		a.setEnrolldate(new Date());
		service.addAdmin(a);
		return mapping.findForward("success");
	}

	public ActionForward modifyadmin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String aid=request.getParameter("aid");
		Admin a=service.findAdmin(Integer.parseInt(aid));
		System.out.println(aid+"===޸ĵָid===");
		System.out.println(a+"===޸Ķ====");
		request.setAttribute("ADMINAID", a);
		return mapping.findForward("success");
	}
	public ActionForward modifyinputadmin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Role role1=new Role();
		Set<Role> set=new HashSet<Role>();
		String aid=request.getParameter("aid");
		AdminForm aform=(AdminForm) form;
		Admin a=aform.getA();
		String[] role=aform.getRole();
		System.out.println(role.length+"==role.length==");
		for(int i=0;i<role.length;i++){
			Integer j=Integer.parseInt(role[i]);
			System.out.println(role[i]+"===roles[x]===");
			role1.setId(j);
			set.add(role1);
			
		}
		a.setRoles(set);
		a.setId(Integer.parseInt(aid));
		a.setEnrolldate(new Date());
		service.modifyAdmin(a);
		return mapping.findForward("success");
	}
	public ActionForward deleteadmin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String daid=request.getParameter("daid");
		Admin a=service.findAdmin(Integer.parseInt(daid));
		service.removeAdmin(a);
		return mapping.findForward("success");
	}
	public ActionForward updself(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Admin a=service.findAdmin(1);
		System.out.println(a);
		request.setAttribute("ADMIN", a);
		return mapping.findForward("success");
	}
	public ActionForward updinputself(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
//		Integer aid=Integer.parseInt(request.getParameter("aid"));
		AdminForm aform=(AdminForm)form;
		System.out.println(aform+"==aform==");
		Admin a=aform.getA();
		a.setId(1);
		System.out.println(a+"==Ϣ޸==");
		service.modifyAdmin(a);
		return mapping.findForward("success");
	}
	public ActionForward listbycond(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		AdminCondForm aform=(AdminCondForm) form;
		Integer type=Integer.parseInt(request.getParameter("type"));
		System.out.println(aform+"===aform===");
		AdminCondDTO dto=aform.getDto();
		System.out.println(dto+"==dto==");
		Collection<Admin> as=service.findAdmin(dto);
		System.out.println(as+"==as==");
		request.setAttribute("ADMINCALL", as);
		if(type==1)
		return mapping.findForward("success");
		else if(type==2) return mapping.findForward("modify");
		else return mapping.findForward("delete");
	}
}
