package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.tarena.oss.admin.pojo.Admin;
import com.tarena.oss.pricing.pojo.Pricing;
import com.tarena.oss.pricing.pojo.PricingCondDTO;
import com.tarena.oss.pricing.service.PricingMgmtService;
import com.tarena.oss.rights.pojo.Rights;
import com.tarena.oss.util.PageParameter;
import com.tarena.oss.util.RightsTools;
import com.tarena.oss.web.forms.PricingCondForm;
import com.tarena.oss.web.forms.PricingForm;

public class PricingAction extends MappingDispatchAction {
//	private ApplicationContext context=new ClassPathXmlApplicationContext("applicationContext.xml");
	private PricingMgmtService service;
	
	public void setService(PricingMgmtService service) {
		this.service = service;
	}

	public ActionForward listRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Admin admin = (Admin) request.getSession().getAttribute("ADMIN");
		System.out.println(admin+"==admin==");
		Integer mid = Integer.valueOf(request.getParameter("mid"));
		System.out.println(mid+"==mid==");
		Set<Rights> rs = RightsTools.getRights(admin, mid);
		request.getSession().setAttribute("MODULE_RIGHTS", rs);
		
		return mapping.findForward("success");
	}
	
	public ActionForward listPricings(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		//õǰҳ
		int currentPage = 0;
		String page = request.getParameter("page");
		if (page==null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
		//ѯ
//		PricingMgmtService  service =(PricingMgmtService) context.getBean("pricingService");
		Collection<Pricing> ps = service.findPricings(new PricingCondDTO(), currentPage);
		request.setAttribute("PRICINGS", ps);
//		 ҳ
		int totalPages = 0;
		int totalRows = service.findPricingCntsByCond(new PricingCondDTO());
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
//		 ÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		// contextPath
		url.append(request.getContextPath());
		System.out.println(url+"===contextPath===");
		// servletPath
		url.append(request.getServletPath());
		System.out.println(url+"===servletPath===");
		// еĲ
		url.append("?");
		System.out.println(url+"===?===");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
					System.out.println(url+"=====for===");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		System.out.println(pagenav);
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		String type = request.getParameter("type");
		if (type.equals("1"))
			return mapping.findForward("list");
		else if (type.equals("2"))
			return mapping.findForward("listforupd");
		else
			return mapping.findForward("listfordel");
	}

	public ActionForward listPricingByCond(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PricingCondForm pcform = (PricingCondForm)form;
		
		/*PricingCondDTO dto = new PricingCondDTO();
		dto.setPname(pcform.getName());
		dto.setLowerBaseFee(pcform.getBaseLower());
		dto.setUpperBaseFee(pcform.getBaseUpper());
		dto.setLowerRateFee(pcform.getRateLower());
		dto.setUpperRateFee(pcform.getRateUpper());*/
		
		PricingCondDTO dto = pcform.getDto();
		
		Collection<Pricing> ps = service.findPricings(dto);
		request.setAttribute("PRICINGS", ps);
		String type = request.getParameter("type");
		System.out.println(type+"==type===");
		if(type.equals("1"))
		return mapping.findForward("list");
		else if (type.equals("2")) 
			return mapping.findForward("listforupd");
		else 
			return mapping.findForward("listfordel");
	}
	public ActionForward addPricing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
//		PricingMgmtService  service =(PricingMgmtService) context.getBean("pricingService");
		PricingForm pform=(PricingForm) form;
		Pricing p=pform.getP();
		System.out.println(p+" ===2==");
		try{
		service.addPricing(p);
		System.out.println(service+"====3===");
		return mapping.findForward("success");
		}catch(RuntimeException e){
			e.printStackTrace();
			String msg="ʧ,ԭ";
			request.setAttribute("msg", msg);
			return mapping.getInputForward();
		}
	}

	public ActionForward modifyPricing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String pid="";
		pid=request.getParameter("pid");
		System.out.println(pid+"====pid==");
		Pricing p=service.findPricing(Integer.parseInt(pid));
		System.out.println(p+"===p===");
		request.setAttribute("Pricing",p );
		return mapping.findForward("Pricingid");
	}

	public ActionForward modifyinputPricing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String id=request.getParameter("mpid");
		PricingForm pform=(PricingForm) form;
		Pricing p=pform.getP();
		p.setId(Integer.parseInt(id));
		System.out.println(p+"===޸===");
		service.modifyPricing(p);
		return mapping.findForward("success");
	}

	public ActionForward delPricing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String dpid=request.getParameter("dpid");
		System.out.println(dpid);
		Pricing p=new Pricing(Integer.parseInt(dpid),"",0,0,"");
		service.removePricing(p);
		return mapping.findForward("success");
	}
	
	
}