package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.admin.pojo.Admin;
import com.tarena.oss.rights.pojo.Module;
import com.tarena.oss.rights.pojo.Operation;
import com.tarena.oss.rights.pojo.Rights;
import com.tarena.oss.rights.pojo.RightsCondDTO;
import com.tarena.oss.rights.service.RightsMgmtService;
import com.tarena.oss.util.PageParameter;
import com.tarena.oss.util.RightsTools;
import com.tarena.oss.web.forms.RightCondForm;

public class RightActon extends MappingDispatchAction{
	private RightsMgmtService rightservice;
	public void setRightservice(RightsMgmtService rightservice) {
		this.rightservice = rightservice;
	}
	
	public ActionForward listRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Admin admin = (Admin) request.getSession().getAttribute("ADMIN");
		Integer mid=Integer.valueOf(request.getParameter("mid"));
		Set<Rights> rs = RightsTools.getRights(admin, mid);
		request.getSession().setAttribute("MODULE_RIGHTS", rs);
		return mapping.findForward("success");
	}
	public ActionForward beforeAdd(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Collection<Module> modules=rightservice.findmodules();
		Collection<Operation> operation=rightservice.findOperation();
		System.out.println(modules);
		request.getSession().setAttribute("MODULES", modules);
		request.setAttribute("operation", operation);
//		Collection<Rights> right = rightservice.findRights();
//		request.setAttribute("rights", right);
		return mapping.findForward("success");
	}
	public ActionForward addRight(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Rights r=new Rights();
		r.setName(request.getParameter("name"));
		r.setOper(rightservice.findOperation(Integer.valueOf(request.getParameter("operateid"))));
		r.setUrl(request.getParameter("url"));
		rightservice.addRight(r);
		return mapping.findForward("success");
	}
	
	public ActionForward beforeModify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Rights r=rightservice.findRight(Integer.valueOf(request.getParameter("rid")));
		request.setAttribute("right", r);
		return mapping.findForward("success");
	}
	
	public ActionForward removeRight(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		rightservice.removeRight(Integer.valueOf(request.getParameter("rid")));
		return mapping.findForward("success");
	}
	
	public ActionForward modifyRight(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Rights r=new Rights();
		r.setId(Integer.valueOf(request.getParameter("rightid")));
		r.setName(request.getParameter("name"));
		r.setOper(rightservice.findOperation(Integer.valueOf(request.getParameter("operateid"))));
		r.setUrl(request.getParameter("url"));
		rightservice.modifyRight(r);
		return mapping.findForward("success");
	}
	
	public ActionForward browseRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		int currentPage = 0;
		String page = request.getParameter("page");
		if (page==null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
		
		Collection<Rights> rs = rightservice.findRights(currentPage);
		
		// ѯrequest
		request.setAttribute("RIGHTS", rs);
		
		// ҳ
		int totalPages = 0;
		int totalRows = rightservice.findRightCnts();
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
		
		StringBuffer url = new StringBuffer();
		// contextPath
		url.append(request.getContextPath());
		// servletPath
		url.append(request.getServletPath());
		// еĲ
		url.append("?");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		String type = request.getParameter("type");
		if (type.equals("1"))
			return mapping.findForward("list");
		else if (type.equals("2"))
			return mapping.findForward("listforupd");
		else
			return mapping.findForward("listfordel");
	}
	public ActionForward browseRightsByCond(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RightCondForm pcform = (RightCondForm)form;
		RightsCondDTO dto = pcform.getDto();
		int currentPage = 0;
		String page = request.getParameter("page");
		if (page==null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
		Collection<Rights> ps = rightservice.findRights(dto, currentPage);
		
		request.setAttribute("RIGHTS", ps);
		
		int totalPages = 0;
		int totalRows = rightservice.findRightCntsByCond(new RightsCondDTO());
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
		
		StringBuffer url = new StringBuffer();
		
		url.append(request.getContextPath());
		url.append(request.getServletPath());
		url.append("?");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		String type = request.getParameter("type");
		if (type.equals("1"))
			return mapping.findForward("list");
		else if (type.equals("2"))
			return mapping.findForward("listforupd");
		else
			return mapping.findForward("listfordel");
	}
	
}
