package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.rights.pojo.Rights;
import com.tarena.oss.rights.pojo.Role;
import com.tarena.oss.rights.service.RightsMgmtService;
import com.tarena.oss.rights.service.RoleMgmtService;
import com.tarena.oss.util.PageParameter;


public class RoleAction extends MappingDispatchAction {
	private RoleMgmtService roleservice;
	private RightsMgmtService rightservice;
	public void setRoleservice(RoleMgmtService roleservice) {
		this.roleservice = roleservice;
	}
	
	public void setRightservice(RightsMgmtService rightservice) {
		this.rightservice = rightservice;
	}

	public ActionForward addRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Role r=new Role();
		r.setName(request.getParameter("rolename"));
		Set<Rights> rs=new TreeSet<Rights>();
		
		String[] s=request.getParameterValues("rightid");
		for(int i=0;i<s.length-1;i++){
			Rights rights=rightservice.findRight(Integer.valueOf(s[i]));
			rs.add(rights);
		}
		r.setRights(rs);
		roleservice.addRolet(r);
		return mapping.findForward("success");
	}
	public ActionForward beforModify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Role r=roleservice.findRole(Integer.valueOf(request.getParameter("rid")));
		Collection<Rights> rs=rightservice.findRights();
		Collection<Rights> temp=null;
		for(Rights r1:rs){
			for(Rights r2:r.getRights()){
				if(r1.getId().equals(r2.getId())){
					rs.remove(r1);
				}
			}
		}
		request.setAttribute("role", r);
		request.setAttribute("rights", rs);
		return mapping.findForward("success");
	}
	public ActionForward modifyRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Role r=roleservice.findRole(Integer.valueOf(request.getParameter("rid")));
		r.setName(request.getParameter("rolename"));
		Set<Rights> rs=new TreeSet<Rights>();
		
		String[] s=request.getParameterValues("rightid");
		for(int i=0;i<s.length-1;i++){
			Rights rights=rightservice.findRight(Integer.valueOf(s[i]));
			rs.add(rights);
		}
		r.setRights(rs);
		roleservice.modifyRole(r);
		return mapping.findForward("success");
	}
	public ActionForward removeRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		roleservice.removeRole(Integer.valueOf(request.getParameter("rid")));
		return mapping.findForward("success");
	}
	public ActionForward browseRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		int currentPage = 0;
		String page = request.getParameter("page");
		if (page==null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
		
		Collection<Role> rs = roleservice.findRoles(currentPage);
		
		// ѯrequest
		request.setAttribute("ROLES", rs);
		
		// ҳ
		int totalPages = 0;
		int totalRows = roleservice.findRoleCnts();
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
		
		StringBuffer url = new StringBuffer();
		// contextPath
		url.append(request.getContextPath());
		// servletPath
		url.append(request.getServletPath());
		// еĲ
		url.append("?");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		String type = request.getParameter("type");
		if (type.equals("1"))
			return mapping.findForward("list");
		else if (type.equals("2"))
			return mapping.findForward("listforupd");
		else
			return mapping.findForward("listfordel");
	}
	
}
