package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.pricing.pojo.PricingCondDTO;
import com.tarena.oss.user.pojo.User;
import com.tarena.oss.user.pojo.UserCondDTO;
import com.tarena.oss.user.service.UserMgmtService;
import com.tarena.oss.util.PageParameter;
import com.tarena.oss.web.forms.UserCondForm;
import com.tarena.oss.web.forms.UserForm;

public class UserAction extends MappingDispatchAction{
	private UserMgmtService service;
	
	public void setService(UserMgmtService service) {
		this.service = service;
	}
	
	/*
	 * ʺŲѯ
	 */
	public ActionForward listUsers(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		int currentPage =0;
		String page =request.getParameter("page");
		if(page==null || page.equals("")){
			currentPage =1;
		}else{
			currentPage =Integer.parseInt(page);
		}
		
		Collection<User> users =service.findUsers(new UserCondDTO(), currentPage);
		request.setAttribute("USERS", users);
		
		int totalPages =0;
		int totalRows =service.findUserCntsByCond(new UserCondDTO());
		if(totalRows % PageParameter.CNT_EACH_PAGE == 0){
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		}else{
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE +1;
		}
		StringBuffer url = new StringBuffer();
		url.append(request.getContextPath());
		url.append(request.getServletPath());
		url.append("?");
		
		Map<String, String[]> params = request.getParameterMap();
		
		if(params !=null && params.size() !=0){
			Set<String> keys =params.keySet();
			for(String key : keys){
				if(key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}
		
		//÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		String type=request.getParameter("type");
		if(type.equals("1")){
			return mapping.findForward("list");
		}else if(type.equals("2")){
			return mapping.findForward("listforupd");
		}else{
			return mapping.findForward("listfordel");
		}
		
	}

	/*
	 * ݲѯѯʺŵϸϢ
	 */
	public ActionForward listUsersByCond(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		int currentPage =0;
		String page =request.getParameter("page");
		if(page==null || page.equals("")){
			currentPage =1;
		}else{
			currentPage =Integer.parseInt(page);
		}
		
		String name = request.getParameter("accname");
		String loginname= request.getParameter("accloginname");
		String status = request.getParameter("accstatus");
		UserCondDTO dto = new UserCondDTO();
		dto.setName(name);
		dto.setLoginname(loginname);
		dto.setStatus(Integer.parseInt(status));
		Collection c=service.findUsers(dto, currentPage);
		
		request.setAttribute("USERS", c);
		
		//ҳ
		int totalPages = 0;
		int totalRows = service.findUserCntsByCond(dto);
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
		
		// ÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		// contextPath
		url.append(request.getContextPath());
		// servletPath
		url.append(request.getServletPath());
		// еĲ
		url.append("?");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
				
		return mapping.findForward("list");
	}
	
	/*
	 * û
	 */
	public ActionForward addUser(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		UserForm f =(UserForm) form;
		User u =f.getUser();
		Date date = new Date();
		u.setEnrolldate(date);
		try{
			service.addUser(u);
			return mapping.findForward("success");
		}catch (RuntimeException e) {
			e.printStackTrace();
			String mesg="Ϣ";
			request.setAttribute("mesg", mesg);
			return mapping.getInputForward();
		}
	}
	
	/*
	 * idѯҪ޸ĵûϸϢ
	 */
	public ActionForward oneUser(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		String str =request.getParameter("uid");
		Integer id =Integer.parseInt(str);
		User user =service.findUser(id);
		request.setAttribute("user", user);
		return mapping.findForward("listuser");
		
	}
	
	/*
	 * ޸ûϢ
	 */
	public ActionForward updateUser(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		String str =request.getParameter("uid");
		Integer id =Integer.parseInt(str);
		
		User user = service.findUser(id);
		Date enrolldate =user.getEnrolldate();
		
		UserForm f =(UserForm) form;		
		f.setEnrolldate(enrolldate);
		User u = f.getUser();
		
		try{
			u.setId(id);
			u.setEnrolldate(enrolldate);
			service.modifyUser(u);
			return mapping.findForward("success");
		}catch(Exception e){
			e.printStackTrace();
			String mesg="޸Ϣ";
			request.setAttribute("mesg", mesg);
			return mapping.getInputForward();
		}
	}
	
	/*
	 * ɾûϢ
	 */
	public ActionForward delUser(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		String str = request.getParameter("uid");
		Integer id = Integer.parseInt(str);
		service.removeUser(id);
		return mapping.findForward("success");		
	}
	
}
