package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.pricing.pojo.Pricing;
import com.tarena.oss.pricing.pojo.PricingCondDTO;
import com.tarena.oss.pricing.service.PricingMgmtService;
import com.tarena.oss.user.pojo.User;
import com.tarena.oss.user.pojo.UserCondDTO;
import com.tarena.oss.user.service.UserMgmtService;
import com.tarena.oss.userservice.pojo.UserService;
import com.tarena.oss.userservice.pojo.UserServiceCondDTO;
import com.tarena.oss.userservice.service.UserServiceMgmtService;
import com.tarena.oss.util.PageParameter;
import com.tarena.oss.web.forms.UserServiceCondForm;
import com.tarena.oss.web.forms.UserServicesForm;

public class UserServiceAction extends MappingDispatchAction {

	//֯UserServiceMgmtService
	private UserServiceMgmtService service;
	public void setService(UserServiceMgmtService service) {
		this.service = service;
	}
	
	//֯PricingMgmtService
	private PricingMgmtService pservice;
	public void setPservice(PricingMgmtService pservice) {
		this.pservice = pservice;
	}
	
	//֯UserMgmtService
	private UserMgmtService uservice;
	public void setUservice(UserMgmtService uservice) {
		this.uservice = uservice;
	}

	/*
	 * ҵʺŲѯ
	 */
	public ActionForward listUserServices(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse reponse) throws Exception {
//		õǰҳ
		int currentPage = 0;
		String page = request.getParameter("page");
		if (page==null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
		Collection<UserService> us =service.findUserServices(new UserServiceCondDTO(), currentPage);
		request.setAttribute("USERSERVICES", us);
		
//		 ҳ
		int totalPages = 0;
		int totalRows = service.findUserServicesByCond(new UserServiceCondDTO());
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
		
		// ÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		// contextPath
		url.append(request.getContextPath());
		// servletPath
		url.append(request.getServletPath());
		// еĲ
		url.append("?");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		
 		String type=request.getParameter("type");
 		if(type.equals("1")){
 			return mapping.findForward("list");
 		}else if(type.equals("2")){
 			return mapping.findForward("listforupd");
 		}else{
 			return mapping.findForward("listfordel");
 		}
 			
	}
	
	/*
	 * ݲѯѯҵʺ
	 */
	public ActionForward listUserServicesByCond(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse reponse) throws Exception {
//		UserServiceCondForm f =(UserServiceCondForm) form;
//		UserServiceCondDTO dto =f.getDto();
//		Collection<UserService>  c =service.findUserServices(dto);
		
		int currentPage =0;
		String page =request.getParameter("page");
		if(page==null || page.equals("")){
			currentPage =1;
		}else{
			currentPage =Integer.parseInt(page);
		}
		
		String username=request.getParameter("username");
		String loginname=request.getParameter("loginname");
		String labip=request.getParameter("labip");
		String status=request.getParameter("status");
		UserServiceCondDTO dto = new UserServiceCondDTO();
		dto.setLabip(labip);
		dto.setStatus(Integer.parseInt(status));
		dto.setLoginname(loginname);
		dto.setUsername(username);
		Collection<UserService>  c=service.findUserServices(dto);
		request.setAttribute("USERSERVICES", c);
		
//		ҳ
		int totalPages = 0;
		int totalRows = service.findUserServicesByCond(dto);
		if (totalRows % PageParameter.CNT_EACH_PAGE == 0)
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE;
		else
			totalPages = totalRows/PageParameter.CNT_EACH_PAGE + 1;
		
		// ÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		// contextPath
		url.append(request.getContextPath());
		// servletPath
		url.append(request.getServletPath());
		// еĲ
		url.append("?");
		Map<String, String[]> params = request.getParameterMap();
		if (params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys){
				if (key.equals("page")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		// ÷ҳַ
		String pagenav = PageParameter.pageNavigator(currentPage, totalPages, url.substring(0, url.length()-1));
		// ҳϢrequest
		request.setAttribute("pagenav", pagenav);
		
		
		return mapping.findForward("list");
	}

	/*
	 * ҵʺ
	 */
	public ActionForward addUserService(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse reponse) throws Exception {
//		System.out.println("111111111");
//		UserServicesForm f= (UserServicesForm) form;
//		System.out.println(f);
//		UserService us = f.getUs();
//		System.out.println("33333333333");
		
		String userid=request.getParameter("userid");
		String priceid=request.getParameter("priceid");
		String loginname=request.getParameter("loginname");
		String loginpassword=request.getParameter("loginpassword");
		String labip=request.getParameter("labip");
		String status=request.getParameter("status");
		
		Date date=new Date();
		UserService us= new UserService();
		us.setLabip(labip);
		us.setStatus(Integer.parseInt(status));
		us.setLoginname(loginname);
		us.setLoginpassword(loginpassword);
		User user = new User();
		user.setId(Integer.parseInt(userid));
		us.setUser(user);
		Pricing pricing = new Pricing();
		pricing.setId(Integer.parseInt(priceid));
		us.setPricing(pricing);
		us.setEnrolldate(date);
		try{
			service.addUserService(us);		
			return mapping.findForward("success");
		}catch(Exception e){
			e.printStackTrace();
			String mesg="Ϣ";
			request.setAttribute("mesg", mesg);
			return mapping.getInputForward();
		}
		
	}
	
	
	
	/*
	 * 3.05 תҳʱUserServicePricing
	 */
	public ActionForward toAddUs(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse reponse) throws Exception {
		Collection<User> user= uservice.findUsers();
		System.out.println(user);
		Collection<Pricing> pricing = pservice.findPricings();
		
		request.setAttribute("user1", user);
		request.setAttribute("pricings", pricing);
		return mapping.findForward("toaddus");
	}
	
	

	/*
	 * ޸ʱidõҵʺŵϢ
	 */
	public ActionForward oneUserService(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse reponse) throws Exception {
		String str=request.getParameter("usid");
		Integer id =Integer.parseInt(str);
		UserService us=service.findUserService(id);
		Collection<Pricing> pricing = pservice.findPricings();
		
		request.setAttribute("us", us);
		request.setAttribute("pricings", pricing);
		return mapping.findForward("listuserservice");
	}
	
	/*
	 * ޸ҵʺ
	 */
	public ActionForward updateUserService(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse reponse) throws Exception {
		String str=request.getParameter("usid");
		Integer id=Integer.parseInt(str);
		UserService us=service.findUserService(id);
		Date enrolldate =us.getEnrolldate();
//		UserServicesForm f =(UserServicesForm) form;
//		f.setEnrolldate(enrolldate);
//		UserService us1=f.getUs();
		
		String loginname=request.getParameter("loginname");
		String loginpassword=request.getParameter("loginpassword");
		String labip=request.getParameter("labip");
		String status=request.getParameter("status");
		
		us.setLoginname(loginname);
		us.setLoginpassword(loginpassword);
		us.setLabip(labip);
		us.setStatus(Integer.parseInt(status));
		
		try{
			us.setId(id);
			us.setEnrolldate(enrolldate);
			service.modifyUserService(us);
			return mapping.findForward("success");
		}catch(Exception e){
			e.printStackTrace();
			String mesg="޸Ϣ";
			request.setAttribute("mesg", mesg);
			return mapping.getInputForward();
		}
	}
	
	/*
	 * ɾҵʺ
	 */
	public ActionForward delUserService(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		String str = request.getParameter("usid");
		Integer id = Integer.parseInt(str);
		service.removeUserService(id);
		return mapping.findForward("success");		
	}

}
