package com.tarena.oss.web.actions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;

import com.tarena.oss.dms.Detailmonths;
import com.tarena.oss.selfservice.service.UserSelfserviceService;
import com.tarena.oss.user.pojo.User;
import com.tarena.oss.user.service.UserMgmtService;
import com.tarena.oss.userservice.pojo.UserService;
import com.tarena.oss.util.PageParameter;
import com.tarena.oss.web.forms.Feequerycondform;
import com.tarena.oss.web.forms.UserFormu;

public class UserselfAction extends MappingDispatchAction{

	private UserSelfserviceService selfService;
	private UserMgmtService uservice;
	public void setUservice(UserMgmtService uservice) {
		this.uservice = uservice;
	}

	public void setSelfService(UserSelfserviceService selfService) {
		this.selfService = selfService;
	}

	public ActionForward reckon(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		//ʵtoqrybill ʾ
		String str = request.getParameter("userid");
		Integer id = Integer.parseInt(str);
		User user = uservice.queryUserByLoginname(id);
		Collection<UserService> cUService = selfService.queryBills();
		
		request.getSession().setAttribute("user", user);
		
		request.setAttribute("self", cUService);
		return mapping.findForward("listBill");
	}

	public ActionForward showreckon(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		Feequerycondform fform = (Feequerycondform) form;
		String loginName = fform.getLoginName();
		int year = fform.getYear();
		int month = fform.getMonth();
		int currentPage = 0;
		String page = request.getParameter("page");
		if(page == null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);
		Collection<UserService> userservice = selfService.queryUserServiceList(loginName,currentPage);
		request.setAttribute("userservice", userservice);
		int totalPage = 0;
		int totalRow = selfService.queryUserServicesCnts(loginName);
		if(totalRow % PageParameter.CNT_EACH_PAGE == 0)
			totalPage = totalRow/PageParameter.CNT_EACH_PAGE;
		else
			totalPage = totalRow/PageParameter.CNT_EACH_PAGE + 1;
		//÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		url.append(request.getContextPath());
		
		url.append(request.getServletPath());
		
		url.append("?");
		//month=1&userid=1&year=2006&loginName=admin1&page=1
		Map<String,String[]> params = request.getParameterMap();
		if(params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys ){
				if(key.equals("page")) continue;
				if(key.equals("month")) continue;
				if(key.equals("userid")) continue;
				if(key.equals("year")) continue;
				if(key.equals("loginName")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		String pagenav = PageParameter.pageNavigator(currentPage, totalPage, url.substring(0, url.length()-1));
		request.setAttribute("pagenav", pagenav);
		
		
		Collection<UserService> cUService = selfService.queryBills();
		request.setAttribute("self", cUService);
		//ͨҵʺŲ
		
		request.setAttribute("loginName", loginName);
		request.setAttribute("year", year);
		request.setAttribute("month", month);
//		request.setAttribute("user", user);
		return mapping.findForward("shows");
	}
	
	public ActionForward showUserinfo(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		String str = request.getParameter("userid");
		Integer id = Integer.parseInt(str);
		User user = uservice.queryUserByLoginname(id);
		request.setAttribute("user", user);
		return mapping.findForward("showuserinfo");
		
	}
	public ActionForward updateUser(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		String str = request.getParameter("userid");
		Integer id = Integer.parseInt(str);
		User user = uservice.queryUserByLoginname(id);
		UserFormu uform = (UserFormu) form;
		uform.setEnrolldate(user.getEnrolldate());
		User userinfo = uform.getUser();
		
		uservice.modifyUser(userinfo);
		return mapping.findForward("update");
	}
	public ActionForward reckonDetail(ActionMapping mapping, ActionForm form, 
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		Feequerycondform fform = (Feequerycondform) form;
		String loginName = fform.getLoginName();
		int year = fform.getYear();
		int month = fform.getMonth();
		int currentPage = 0;
		String page = request.getParameter("page");
		if(page == null || page.equals(""))
			currentPage = 1;
		else
			currentPage = Integer.parseInt(page);

		Collection<Detailmonths> months = selfService.queryDetailmonths_intByMonth(year, month);
		
		request.getSession().setAttribute("months", months);
		
		int totalPage = 0;
		int totalRow = selfService.queryUserServicesCnts();
		if(totalRow % PageParameter.CNT_EACH_PAGE == 0)
			totalPage = totalRow/PageParameter.CNT_EACH_PAGE;
		else
			totalPage = totalRow/PageParameter.CNT_EACH_PAGE + 1;
		//÷ҳеurl
		StringBuffer url = new StringBuffer();
		
		url.append(request.getContextPath());
		
		url.append(request.getServletPath());
		
		url.append("?");
		//month=1&userid=1&year=2006&loginName=admin1&page=1
		Map<String,String[]> params = request.getParameterMap();
		if(params != null && params.size() != 0){
			Set<String> keys = params.keySet();
			for(String key : keys ){
				if(key.equals("page")) continue;
				if(key.equals("month")) continue;
				if(key.equals("userid")) continue;
				if(key.equals("year")) continue;
				if(key.equals("loginName")) continue;
				String[] values = params.get(key);
				for(String value : values){
					url.append(key).append("=").append(value).append("&");
				}
			}
		}

		String pagenav = PageParameter.pageNavigator(currentPage, totalPage, url.substring(0, url.length()-1));
		request.setAttribute("pagenav", pagenav);
		String str = request.getParameter("userid");
		Integer id = Integer.parseInt(str);
		
		request.setAttribute("loginName", loginName);
		request.setAttribute("year", year);
		request.setAttribute("month", month);
		
		
		User user = uservice.queryUserByLoginname(id);
		
		UserService cUService = selfService.queryBill();
		
		request.getSession().setAttribute("user", user);
		
		request.getSession().setAttribute("service", cUService);
		return mapping.findForward("detail");
		
	}
}
