/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesException;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.Definitions;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsImpl;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.ReloadableDefinitionsFactory;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.locale.impl.DefaultLocaleResolver;
import org.apache.tiles.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlDefinitionsFactory
implements DefinitionsFactory,
ReloadableDefinitionsFactory {
    private static final Log LOG = LogFactory.getLog(UrlDefinitionsFactory.class);
    protected List<Object> sources = new ArrayList<Object>();
    protected DefinitionsReader reader;
    protected Map<String, Long> lastModifiedDates = new HashMap<String, Long>();
    private List<Locale> processedLocales = new ArrayList<Locale>();
    private Definitions definitions;
    private LocaleResolver localeResolver;

    @Override
    public void init(Map<String, String> params) throws TilesException {
        String readerClassName = params.get("org.apache.tiles.definition.DefinitionsReader");
        this.reader = readerClassName != null ? (DefinitionsReader)ClassUtil.instantiate(readerClassName) : new DigesterDefinitionsReader();
        this.reader.init(params);
        String resolverClassName = params.get("org.apache.tiles.locale.LocaleResolver");
        this.localeResolver = resolverClassName != null ? (LocaleResolver)ClassUtil.instantiate(resolverClassName) : new DefaultLocaleResolver();
        this.localeResolver.init(params);
    }

    protected Definitions getDefinitions() throws DefinitionsFactoryException {
        if (this.definitions == null) {
            this.definitions = this.readDefinitions();
        }
        return this.definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String name, TilesRequestContext tilesContext) throws DefinitionsFactoryException {
        Definitions definitions = this.getDefinitions();
        Locale locale = null;
        if (tilesContext != null) {
            locale = this.localeResolver.resolveLocale(tilesContext);
            if (!this.isContextProcessed(tilesContext)) {
                Definitions definitions2 = definitions;
                synchronized (definitions2) {
                    this.addDefinitions(definitions, tilesContext);
                }
            }
        }
        return definitions.getDefinition(name, locale);
    }

    @Override
    public void addSource(Object source) throws DefinitionsFactoryException {
        if (source == null) {
            throw new DefinitionsFactoryException("Source object must not be null");
        }
        if (!(source instanceof URL)) {
            throw new DefinitionsFactoryException("Source object must be an URL");
        }
        this.sources.add(source);
    }

    protected void addDefinitions(Definitions definitions, TilesRequestContext tilesContext) throws DefinitionsFactoryException {
        Locale locale = this.localeResolver.resolveLocale(tilesContext);
        if (this.isContextProcessed(tilesContext)) {
            return;
        }
        if (locale == null) {
            return;
        }
        this.processedLocales.add(locale);
        List<String> postfixes = UrlDefinitionsFactory.calculatePostfixes(locale);
        HashMap<String, Definition> localeDefsMap = new HashMap<String, Definition>();
        for (String postfix : postfixes) {
            for (Object source : this.sources) {
                URL url = (URL)source;
                String path = url.toExternalForm();
                String newPath = this.concatPostfix(path, postfix);
                try {
                    URL newUrl = new URL(newPath);
                    URLConnection connection = newUrl.openConnection();
                    connection.connect();
                    this.lastModifiedDates.put(newUrl.toExternalForm(), connection.getLastModified());
                    Map<String, Definition> defsMap = this.reader.read(connection.getInputStream());
                    if (defsMap == null) continue;
                    localeDefsMap.putAll(defsMap);
                }
                catch (FileNotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("File " + newPath + " not found, continue"));
                }
                catch (IOException e) {
                    throw new DefinitionsFactoryException("I/O error processing configuration.");
                }
            }
        }
        definitions.addDefinitions(localeDefsMap, this.localeResolver.resolveLocale(tilesContext));
    }

    @Override
    public Definitions readDefinitions() throws DefinitionsFactoryException {
        Definitions definitions = this.createDefinitions();
        try {
            for (Object source1 : this.sources) {
                URL source = (URL)source1;
                URLConnection connection = source.openConnection();
                connection.connect();
                this.lastModifiedDates.put(source.toExternalForm(), connection.getLastModified());
                Map<String, Definition> defsMap = this.reader.read(connection.getInputStream());
                definitions.addDefinitions(defsMap);
            }
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O error accessing source.", e);
        }
        return definitions;
    }

    protected boolean isContextProcessed(TilesRequestContext tilesContext) {
        return this.processedLocales.contains(this.localeResolver.resolveLocale(tilesContext));
    }

    protected Definitions createDefinitions() {
        return new DefinitionsImpl();
    }

    protected String concatPostfix(String name, String postfix) {
        if (postfix == null) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        int lastNameStart = name.lastIndexOf(File.pathSeparator);
        if (dotIndex < 1 || dotIndex < lastNameStart) {
            return name + postfix;
        }
        String ext = name.substring(dotIndex);
        name = name.substring(0, dotIndex);
        return name + postfix + ext;
    }

    protected static List<String> calculatePostfixes(Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.add("");
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer();
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(temp.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws DefinitionsFactoryException {
        LOG.debug((Object)"Updating Tiles definitions. . .");
        Definitions definitions = this.definitions;
        synchronized (definitions) {
            Definitions newDefs = this.readDefinitions();
            this.definitions.reset();
            this.definitions.addDefinitions(newDefs.getBaseDefinitions());
        }
    }

    @Override
    public boolean refreshRequired() {
        boolean status = false;
        Set<String> urls = this.lastModifiedDates.keySet();
        try {
            for (String urlPath : urls) {
                Long lastModifiedDate = this.lastModifiedDates.get(urlPath);
                URL url = new URL(urlPath);
                URLConnection connection = url.openConnection();
                connection.connect();
                long newModDate = connection.getLastModified();
                if (newModDate == lastModifiedDate) continue;
                status = true;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while monitoring update times.", (Throwable)e);
            return true;
        }
        return status;
    }
}

